/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.FactionManager;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.context.Context;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.screens.BorderDrawer;
import org.destinationsol.game.screens.CameraKeyboardControl;
import org.destinationsol.game.screens.CollisionWarnDrawer;
import org.destinationsol.game.screens.DmgWarnDrawer;
import org.destinationsol.game.screens.GameScreens;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.screens.RightPaneLayout;
import org.destinationsol.game.screens.ShipControllerControl;
import org.destinationsol.game.screens.ShipKbControl;
import org.destinationsol.game.screens.ShipMixedControl;
import org.destinationsol.game.screens.ShipMouseControl;
import org.destinationsol.game.screens.ShipUiControl;
import org.destinationsol.game.screens.SunWarnDrawer;
import org.destinationsol.game.screens.TalkScreen;
import org.destinationsol.game.screens.WarnDrawer;
import org.destinationsol.game.screens.ZoneNameAnnouncer;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.SolUiScreen;
import org.destinationsol.ui.UiDrawer;

public class MainGameScreen
extends SolUiBaseScreen {
    private static final float ICON_SZ = 0.03f;
    private static final float BAR_SZ = 0.14999999f;
    private static final int MAX_ICON_COUNT = 3;
    static final float CELL_SZ = 0.17f;
    private static final float H_PAD = 0.005f;
    private static final float V_PAD = 0.005f;
    static final float HELPER_ROW_1 = 0.49f;
    private static final float HELPER_ROW_2 = 0.405f;
    private static final float HELPER_ROW_3 = 0.32f;
    public final ShipUiControl shipControl;
    public final SolUiControl mapControl;
    public final SolUiControl inventoryControl;
    public final SolUiControl talkControl;
    private final SolUiControl mercControl;
    private final SolUiControl freeCamControl;
    private final SolUiControl menuControl;
    private final SolUiControl pauseControl;
    private final SolUiControl consoleControlGrave;
    private final SolUiControl consoleControlF1;
    private final CameraKeyboardControl cameraControl;
    private final ZoneNameAnnouncer zoneNameAnnouncer;
    private final BorderDrawer borderDrawer;
    private final TextureAtlas.AtlasRegion lifeTexture;
    private final TextureAtlas.AtlasRegion infinityTexture;
    private final TextureAtlas.AtlasRegion waitTexture;
    private final TextureAtlas.AtlasRegion compassTexture;
    private final Color myCompassTint;
    private final TextPlace myLifeTp;
    private final TextPlace myRepairsExcessTp;
    private final TextPlace myShieldLifeTp;
    private final TextPlace myG1AmmoTp;
    private final TextPlace myG1AmmoExcessTp;
    private final TextPlace myG2AmmoTp;
    private final TextPlace myG2AmmoExcessTp;
    private final TextPlace myChargesExcessTp;
    private final TextPlace myMoneyExcessTp;
    private final SolApplication solApplication;
    private List<SolUiScreen> gameOverlayScreens = new ArrayList<SolUiScreen>();
    private List<WarnDrawer> warnDrawers = new ArrayList<WarnDrawer>();

    MainGameScreen(RightPaneLayout rightPaneLayout, Context context) {
        DisplayDimensions displayDimensions = SolApplication.displayDimensions;
        this.solApplication = context.get(SolApplication.class);
        GameOptions gameOptions = this.solApplication.getOptions();
        switch (gameOptions.controlType) {
            case KEYBOARD: {
                this.shipControl = new ShipKbControl(this.solApplication, this.controls);
                break;
            }
            case MOUSE: {
                this.shipControl = new ShipMouseControl();
                break;
            }
            case CONTROLLER: {
                this.shipControl = new ShipControllerControl(this.solApplication);
                break;
            }
            default: {
                this.shipControl = new ShipMixedControl(this.solApplication, this.controls);
            }
        }
        boolean mobile = this.solApplication.isMobile();
        float lastCol = displayDimensions.getRatio() - 0.17f;
        Rectangle menuArea = mobile ? MainGameScreen.btn(0.0f, 0.405f, true) : rightPaneLayout.buttonRect(0);
        this.menuControl = new SolUiControl(menuArea, true, gameOptions.getKeyMenu());
        this.menuControl.setDisplayName("Menu");
        this.controls.add(this.menuControl);
        Rectangle mapArea = mobile ? MainGameScreen.btn(0.0f, 0.49f, true) : rightPaneLayout.buttonRect(1);
        this.mapControl = new SolUiControl(mapArea, true, gameOptions.getKeyMap());
        this.mapControl.setDisplayName("Map");
        this.controls.add(this.mapControl);
        Rectangle invArea = mobile ? MainGameScreen.btn(lastCol, 0.49f, true) : rightPaneLayout.buttonRect(2);
        this.inventoryControl = new SolUiControl(invArea, true, gameOptions.getKeyInventory());
        this.inventoryControl.setDisplayName("Items");
        this.controls.add(this.inventoryControl);
        Rectangle talkArea = mobile ? MainGameScreen.btn(lastCol, 0.405f, true) : rightPaneLayout.buttonRect(3);
        this.talkControl = new SolUiControl(talkArea, true, gameOptions.getKeyTalk());
        this.talkControl.setDisplayName("Talk");
        this.controls.add(this.talkControl);
        Rectangle mercArea = mobile ? MainGameScreen.btn(lastCol, 0.32f, true) : rightPaneLayout.buttonRect(4);
        this.mercControl = new SolUiControl(mercArea, true, gameOptions.getKeyMercenaryInteraction());
        this.mercControl.setDisplayName("Mercs");
        this.controls.add(this.mercControl);
        this.freeCamControl = new SolUiControl(null, false, gameOptions.getKeyFreeCameraMovement());
        this.controls.add(this.freeCamControl);
        this.pauseControl = new SolUiControl(null, true, gameOptions.getKeyPause());
        this.controls.add(this.pauseControl);
        this.cameraControl = new CameraKeyboardControl(gameOptions, this.controls);
        this.consoleControlGrave = new SolUiControl(null, true, 68);
        this.consoleControlF1 = new SolUiControl(null, true, 244);
        this.controls.add(this.consoleControlGrave);
        this.controls.add(this.consoleControlF1);
        this.warnDrawers.add(new SunWarnDrawer());
        this.warnDrawers.add(new DmgWarnDrawer());
        this.warnDrawers.add(new CollisionWarnDrawer());
        this.warnDrawers.add(new NoShieldWarn());
        this.warnDrawers.add(new NoArmorWarn());
        this.warnDrawers.add(new EnemyWarn());
        this.zoneNameAnnouncer = new ZoneNameAnnouncer();
        this.borderDrawer = new BorderDrawer();
        this.lifeTexture = Assets.getAtlasRegion("engine:iconLife");
        this.infinityTexture = Assets.getAtlasRegion("engine:iconInfinity");
        this.waitTexture = Assets.getAtlasRegion("engine:iconWait");
        this.compassTexture = Assets.getAtlasRegion("engine:uiCompass");
        this.myCompassTint = SolColor.col(1.0f, 0.0f);
        this.myLifeTp = new TextPlace(SolColor.W50);
        this.myRepairsExcessTp = new TextPlace(SolColor.WHITE);
        this.myShieldLifeTp = new TextPlace(SolColor.W50);
        this.myG1AmmoTp = new TextPlace(SolColor.W50);
        this.myG1AmmoExcessTp = new TextPlace(SolColor.WHITE);
        this.myG2AmmoTp = new TextPlace(SolColor.W50);
        this.myG2AmmoExcessTp = new TextPlace(SolColor.WHITE);
        this.myChargesExcessTp = new TextPlace(SolColor.WHITE);
        this.myMoneyExcessTp = new TextPlace(SolColor.WHITE);
    }

    public static Rectangle btn(float x, float y, boolean halfHeight) {
        float gap = 0.01f;
        float cellH = 0.17f;
        if (halfHeight) {
            cellH /= 2.0f;
        }
        return new Rectangle(x + gap, y + gap, 0.17f - gap * 2.0f, cellH - gap * 2.0f);
    }

    private void maybeDrawHeight(UiDrawer drawer) {
        SolGame game = this.solApplication.getGame();
        Planet np = game.getPlanetManager().getNearestPlanet();
        SolCam cam = game.getCam();
        Vector2 camPos = cam.getPosition();
        if (np != null && np.getPosition().dst(camPos) < np.getFullHeight()) {
            this.drawHeight(drawer, np, camPos, cam.getAngle());
        }
    }

    private void drawHeight(UiDrawer drawer, Planet np, Vector2 camPos, float camAngle) {
        float toPlanet = camPos.dst(np.getPosition());
        if (14.0f < (toPlanet -= np.getGroundHeight())) {
            return;
        }
        float perc = toPlanet / 14.0f;
        float sz = 0.08f;
        float maxY = 1.0f - sz / 2.0f;
        float y = 1.0f - perc;
        this.myCompassTint.a = SolMath.clamp(1.5f * y);
        if (maxY < y) {
            y = maxY;
        }
        float angle = np.getAngle() - camAngle;
        drawer.draw((TextureRegion)this.compassTexture, sz, sz, sz / 2.0f, sz / 2.0f, sz / 2.0f, y, angle, this.myCompassTint);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        boolean isOn;
        InventoryScreen is;
        SolGame game = solApplication.getGame();
        SolInputManager inputMan = solApplication.getInputManager();
        GameScreens screens = game.getScreens();
        Hero hero = game.getHero();
        for (WarnDrawer warnDrawer : this.warnDrawers) {
            warnDrawer.update(game);
        }
        this.zoneNameAnnouncer.update(game);
        if (this.menuControl.isJustOff()) {
            inputMan.setScreen(solApplication, screens.menuScreen);
        }
        boolean controlsEnabled = inputMan.getTopScreen() == this;
        this.shipControl.update(solApplication, controlsEnabled);
        if (this.mapControl.isJustOff()) {
            inputMan.setScreen(solApplication, screens.mapScreen);
        }
        this.inventoryControl.setEnabled(hero.isNonTranscendent());
        if (hero.isNonTranscendent() && !inputMan.isScreenOn(screens.inventoryScreen) && hero.getItemContainer().hasNew()) {
            this.inventoryControl.enableWarn();
        }
        if (this.inventoryControl.isJustOff()) {
            is = screens.inventoryScreen;
            isOn = inputMan.isScreenOn(is);
            inputMan.setScreen(solApplication, screens.mainGameScreen);
            if (!isOn) {
                is.showInventory.setTarget(hero.getShip());
                is.setOperations(is.showInventory);
                inputMan.addScreen(solApplication, is);
            }
        }
        this.mercControl.setEnabled(hero.isNonTranscendent());
        if (hero.isNonTranscendent() && !inputMan.isScreenOn(screens.inventoryScreen) && hero.getMercs().hasNew()) {
            this.mercControl.enableWarn();
        }
        if (this.mercControl.isJustOff()) {
            is = screens.inventoryScreen;
            isOn = inputMan.isScreenOn(is);
            inputMan.setScreen(solApplication, screens.mainGameScreen);
            if (!isOn) {
                is.setOperations(is.chooseMercenaryScreen);
                inputMan.addScreen(solApplication, is);
                game.getHero().getMercs().markAllAsSeen();
            }
        }
        SolCam.DIRECT_CAM_CONTROL = this.freeCamControl.isOn();
        this.updateTalk(game);
        if (this.pauseControl.isJustOff()) {
            game.setPaused(!game.isPaused());
        }
        if (this.consoleControlGrave.isJustOff() || this.consoleControlF1.isJustOff()) {
            inputMan.setScreen(solApplication, screens.consoleScreen);
        }
        for (SolUiScreen screen : this.gameOverlayScreens) {
            screen.updateCustom(solApplication, inputPointers, clickedOutside);
        }
    }

    private void updateTalk(SolGame game) {
        Hero hero = game.getHero();
        if (hero.isTranscendent()) {
            this.talkControl.setEnabled(false);
            return;
        }
        FactionManager factionManager = game.getFactionMan();
        SolShip target = null;
        float minDist = 1.0f;
        float har = hero.getHull().config.getApproxRadius();
        List<SolObject> objs = game.getObjectManager().getObjects();
        for (SolObject o : objs) {
            float ar;
            float dst;
            if (!(o instanceof SolShip)) continue;
            SolShip ship = (SolShip)o;
            if (factionManager.areEnemies(hero.getShip(), ship) || ship.getTradeContainer() == null || minDist < (dst = ship.getPosition().dst(hero.getPosition())) - har - (ar = ship.getHull().config.getApproxRadius())) continue;
            target = ship;
            minDist = dst;
        }
        this.talkControl.setEnabled(target != null);
        if (this.talkControl.isJustOff()) {
            TalkScreen talkScreen = game.getScreens().talkScreen;
            SolInputManager inputMan = this.solApplication.getInputManager();
            boolean isOn = inputMan.isScreenOn(talkScreen);
            inputMan.setScreen(this.solApplication, this);
            if (!isOn) {
                talkScreen.setTarget(target);
                inputMan.addScreen(this.solApplication, talkScreen);
            }
        }
    }

    private boolean drawGunStat(UiDrawer uiDrawer, Hero hero, boolean secondary, float col0, float col1, float col2, float y) {
        float curr;
        float max;
        Gun g = hero.getHull().getGun(secondary);
        if (g == null) {
            return false;
        }
        TextureAtlas.AtlasRegion tex = g.config.icon;
        uiDrawer.draw((TextureRegion)tex, 0.03f, 0.03f, 0.0f, 0.0f, col0, y, 0.0f, SolColor.WHITE);
        if (g.reloadAwait > 0.0f) {
            max = g.config.reloadTime;
            curr = max - g.reloadAwait;
        } else {
            curr = g.ammo;
            max = g.config.clipConf.size;
        }
        TextPlace ammoTp = g.reloadAwait > 0.0f ? null : (secondary ? this.myG2AmmoTp : this.myG1AmmoTp);
        this.drawBar(uiDrawer, col1, y, curr, max, ammoTp);
        if (g.reloadAwait > 0.0f) {
            this.drawWait(uiDrawer, col1, y);
        }
        if (!g.config.clipConf.infinite) {
            int clipCount = hero.getItemContainer().count(g.config.clipConf.example);
            this.drawIcons(uiDrawer, col2, y, clipCount, g.config.clipConf.icon, secondary ? this.myG2AmmoExcessTp : this.myG1AmmoExcessTp);
        } else {
            uiDrawer.draw((TextureRegion)this.infinityTexture, 0.03f, 0.03f, 0.0f, 0.0f, col2, y, 0.0f, SolColor.WHITE);
        }
        return true;
    }

    private void drawWait(UiDrawer uiDrawer, float x, float y) {
        uiDrawer.draw((TextureRegion)this.waitTexture, 0.03f, 0.03f, 0.015f, 0.015f, x + 0.074999996f, y + 0.015f, 0.0f, SolColor.WHITE);
    }

    private void drawBar(UiDrawer uiDrawer, float x, float y, float curr, float max, TextPlace tp) {
        float perc = curr / max;
        uiDrawer.draw(UiDrawer.whiteTexture, 0.14999999f, 0.03f, 0.0f, 0.0f, x, y, 0.0f, SolColor.UI_DARK);
        uiDrawer.draw(UiDrawer.whiteTexture, 0.14999999f * perc, 0.03f, 0.0f, 0.0f, x, y, 0.0f, SolColor.UI_LIGHT);
        if (tp != null && max > 1.0f && curr > 0.0f) {
            tp.text = (int)curr + "/" + (int)max;
            tp.position.set(x + 0.074999996f, y + 0.015f);
        }
    }

    private void drawIcons(UiDrawer uiDrawer, float x, float y, int count, TextureAtlas.AtlasRegion tex, TextPlace textPlace) {
        int excess = count - 3;
        int iconCount = excess > 0 ? 3 : count;
        for (int i = 0; i < iconCount; ++i) {
            uiDrawer.draw((TextureRegion)tex, 0.03f, 0.03f, 0.0f, 0.0f, x, y, 0.0f, SolColor.WHITE);
            x += 0.035f;
        }
        if (excess > 0) {
            this.updateTextPlace(x, y, "+" + excess, textPlace);
        }
    }

    private void updateTextPlace(float x, float y, String text, TextPlace textPlace) {
        textPlace.text = text;
        textPlace.position.set(x + 0.015f, y + 0.015f);
    }

    @Override
    public void drawImages(UiDrawer uiDrawer, SolApplication solApplication) {
        this.myLifeTp.text = null;
        this.myRepairsExcessTp.text = null;
        this.myShieldLifeTp.text = null;
        this.myG1AmmoTp.text = null;
        this.myG1AmmoExcessTp.text = null;
        this.myG2AmmoTp.text = null;
        this.myG2AmmoExcessTp.text = null;
        this.myChargesExcessTp.text = null;
        this.myMoneyExcessTp.text = null;
        this.maybeDrawHeight(uiDrawer);
        this.borderDrawer.draw(uiDrawer, solApplication);
        SolGame game = solApplication.getGame();
        Hero hero = game.getHero();
        if (hero.isNonTranscendent()) {
            ShipAbility ability;
            SolItem abilityChargeEx;
            float row = 0.024999999f;
            float col0 = 0.024999999f;
            float col1 = col0 + 0.03f + 0.005f;
            float col2 = col1 + 0.14999999f + 0.005f;
            Shield shield = hero.getShield();
            if (shield != null) {
                uiDrawer.draw((TextureRegion)shield.getIcon(game), 0.03f, 0.03f, 0.0f, 0.0f, col0, row, 0.0f, SolColor.WHITE);
                this.drawBar(uiDrawer, col1, row, MathUtils.floor((float)shield.getLife()), shield.getMaxLife(), this.myShieldLifeTp);
                row += 0.035f;
            }
            uiDrawer.draw((TextureRegion)this.lifeTexture, 0.03f, 0.03f, 0.0f, 0.0f, col0, row, 0.0f, SolColor.WHITE);
            this.drawBar(uiDrawer, col1, row, MathUtils.floor((float)hero.getLife()), hero.getHull().config.getMaxLife(), this.myLifeTp);
            int repairKitCount = hero.getItemContainer().count(game.getItemMan().getRepairExample());
            ItemManager itemManager = game.getItemMan();
            this.drawIcons(uiDrawer, col2, row, repairKitCount, itemManager.repairIcon, this.myRepairsExcessTp);
            boolean consumed = this.drawGunStat(uiDrawer, hero, false, col0, col1, col2, row += 0.035f);
            if (consumed) {
                row += 0.035f;
            }
            if (consumed = this.drawGunStat(uiDrawer, hero, true, col0, col1, col2, row)) {
                row += 0.035f;
            }
            SolItem solItem = abilityChargeEx = (ability = hero.getAbility()) == null ? null : ability.getConfig().getChargeExample();
            if (abilityChargeEx != null) {
                int abilityChargeCount = hero.getItemContainer().count(abilityChargeEx);
                TextureAtlas.AtlasRegion icon = abilityChargeEx.getIcon(game);
                uiDrawer.draw((TextureRegion)icon, 0.03f, 0.03f, 0.0f, 0.0f, col0, row, 0.0f, SolColor.WHITE);
                float chargePercentage = 1.0f - SolMath.clamp(hero.getAbilityAwait() / ability.getConfig().getRechargeTime());
                this.drawBar(uiDrawer, col1, row, chargePercentage, 1.0f, null);
                if (chargePercentage < 1.0f) {
                    this.drawWait(uiDrawer, col1, row);
                }
                this.drawIcons(uiDrawer, col2, row, abilityChargeCount, icon, this.myChargesExcessTp);
                row += 0.035f;
            }
            uiDrawer.draw((TextureRegion)game.getItemMan().moneyIcon, 0.03f, 0.03f, 0.0f, 0.0f, col0, row, 0.0f, SolColor.WHITE);
            this.myMoneyExcessTp.text = Integer.toString(Math.round(hero.getMoney()));
            this.myMoneyExcessTp.position.set(col1, row + 0.015f);
        }
        int drawPlace = 0;
        for (WarnDrawer wd : this.warnDrawers) {
            if (!(wd.drawPercentage > 0.0f)) continue;
            wd.draw(uiDrawer, drawPlace++);
        }
        for (SolUiScreen screen : this.gameOverlayScreens) {
            screen.drawImages(uiDrawer, solApplication);
        }
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        this.myLifeTp.draw(uiDrawer);
        this.myRepairsExcessTp.draw(uiDrawer);
        this.myShieldLifeTp.draw(uiDrawer);
        this.myG1AmmoTp.draw(uiDrawer);
        this.myG1AmmoExcessTp.draw(uiDrawer);
        this.myG2AmmoTp.draw(uiDrawer);
        this.myG2AmmoExcessTp.draw(uiDrawer);
        this.myChargesExcessTp.draw(uiDrawer);
        this.myMoneyExcessTp.draw(uiDrawer, UiDrawer.TextAlignment.LEFT);
        int drawPlace = 0;
        for (WarnDrawer warnDrawer : this.warnDrawers) {
            if (!(warnDrawer.drawPercentage > 0.0f)) continue;
            warnDrawer.drawText(uiDrawer, drawPlace++);
        }
        this.zoneNameAnnouncer.drawText(uiDrawer);
        for (SolUiScreen screen : this.gameOverlayScreens) {
            screen.drawText(uiDrawer, solApplication);
        }
    }

    @Override
    public void blurCustom(SolApplication solApplication) {
        this.shipControl.blur();
        for (SolUiScreen screen : this.gameOverlayScreens) {
            screen.blurCustom(solApplication);
        }
    }

    public boolean isLeft() {
        return this.shipControl.isLeft();
    }

    public boolean isRight() {
        return this.shipControl.isRight();
    }

    public boolean isUp() {
        return this.shipControl.isUp();
    }

    public boolean isDown() {
        return this.shipControl.isDown();
    }

    public boolean isShoot() {
        return this.shipControl.isShoot();
    }

    public boolean isShoot2() {
        return this.shipControl.isShoot2();
    }

    public boolean isAbility() {
        return this.shipControl.isAbility();
    }

    public boolean isCameraUp() {
        return this.cameraControl.isUp();
    }

    public boolean isCameraDown() {
        return this.cameraControl.isDown();
    }

    public boolean isCameraLeft() {
        return this.cameraControl.isLeft();
    }

    public boolean isCameraRight() {
        return this.cameraControl.isRight();
    }

    public void addOverlayScreen(SolUiScreen screen) {
        this.gameOverlayScreens.add(screen);
        screen.onAdd(this.solApplication);
        this.controls.addAll(screen.getControls());
    }

    public void removeOverlayScreen(SolUiScreen screen) {
        this.gameOverlayScreens.remove(screen);
        this.controls.removeAll(screen.getControls());
    }

    public boolean hasOverlay(SolUiScreen screen) {
        return this.gameOverlayScreens.contains(screen);
    }

    public void addWarnDrawer(WarnDrawer drawer) {
        if (!this.warnDrawers.contains(drawer)) {
            this.warnDrawers.add(drawer);
        }
    }

    public void removeWarnDrawer(WarnDrawer drawer) {
        this.warnDrawers.remove(drawer);
    }

    public boolean hasWarnDrawer(WarnDrawer drawer) {
        return this.warnDrawers.contains(drawer);
    }

    private static class NoShieldWarn
    extends WarnDrawer {
        NoShieldWarn() {
            super("No Shield");
        }

        @Override
        protected boolean shouldWarn(SolGame game) {
            Hero hero = game.getHero();
            return hero.isNonTranscendent() && hero.getShield() == null;
        }
    }

    private static class NoArmorWarn
    extends WarnDrawer {
        NoArmorWarn() {
            super("No Armor");
        }

        @Override
        protected boolean shouldWarn(SolGame game) {
            Hero hero = game.getHero();
            return hero.isNonTranscendent() && hero.getArmor() == null;
        }
    }

    private static class EnemyWarn
    extends WarnDrawer {
        EnemyWarn() {
            super("Dangerous\nEnemy");
        }

        @Override
        protected boolean shouldWarn(SolGame game) {
            Hero hero = game.getHero();
            if (hero.isTranscendent()) {
                return false;
            }
            float heroCap = HardnessCalc.getShipDmgCap(hero.getShip());
            List<SolObject> objs = game.getObjectManager().getObjects();
            FactionManager fm = game.getFactionMan();
            SolCam cam = game.getCam();
            float viewDist = cam.getViewDistance();
            float dps = 0.0f;
            for (SolObject o : objs) {
                SolShip ship;
                if (!(o instanceof SolShip) || viewDist < (ship = (SolShip)o).getPosition().dst(hero.getPosition()) || !fm.areEnemies(hero.getShip(), ship) || !HardnessCalc.isDangerous(heroCap, dps += HardnessCalc.getShipDps(ship))) continue;
                return true;
            }
            return false;
        }
    }

    public static class TextPlace {
        public final Color color;
        public String text;
        public Vector2 position = new Vector2();

        TextPlace(Color col) {
            this.color = new Color(col);
        }

        public void draw(UiDrawer uiDrawer) {
            uiDrawer.drawString(this.text, this.position.x, this.position.y, 0.7f, true, this.color);
        }

        public void draw(UiDrawer uiDrawer, UiDrawer.TextAlignment align) {
            uiDrawer.drawString(this.text, this.position.x, this.position.y, 0.7f, align, true, this.color);
        }
    }
}

