/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.MapDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.screens.MainGameScreen;
import org.destinationsol.game.screens.RightPaneLayout;
import org.destinationsol.game.screens.ShipMouseControl;
import org.destinationsol.game.screens.ShipUiControl;
import org.destinationsol.game.screens.WaypointCreationScreen;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.Waypoint;

public class MapScreen
extends SolUiBaseScreen {
    private final SolUiControl zoomOutControl;
    public final SolUiControl closeControl;
    public final SolUiControl zoomInControl;
    private final SolUiControl addWaypointControl;
    private final SolUiControl removeWaypointControl;
    private final String NEW_WAYPOINT_TEXT = "Marker+";
    private final String REMOVE_WAYPOINT_TEXT = "Marker-";
    private final String CANCEL_TEXT = "Cancel";
    private final int MIN_WAYPOINT_DIST = 5;
    private boolean isPickingWaypointSpot = false;
    private boolean isPickingWaypointToRemove = false;

    MapScreen(RightPaneLayout rightPaneLayout, boolean mobile, GameOptions gameOptions) {
        Rectangle closeArea = mobile ? MainGameScreen.btn(0.0f, 0.49f, true) : rightPaneLayout.buttonRect(1);
        this.closeControl = new SolUiControl(closeArea, true, gameOptions.getKeyMap(), gameOptions.getKeyClose());
        this.closeControl.setDisplayName("Close");
        this.controls.add(this.closeControl);
        float row0 = 0.83f;
        float row1 = row0 - 0.17f;
        Rectangle zoomInArea = mobile ? MainGameScreen.btn(0.0f, row1, false) : rightPaneLayout.buttonRect(2);
        this.zoomInControl = new SolUiControl(zoomInArea, true, gameOptions.getKeyZoomIn());
        this.zoomInControl.setDisplayName("Zoom In");
        this.controls.add(this.zoomInControl);
        Rectangle zoomOutArea = mobile ? MainGameScreen.btn(0.0f, row0, false) : rightPaneLayout.buttonRect(3);
        this.zoomOutControl = new SolUiControl(zoomOutArea, true, gameOptions.getKeyZoomOut());
        this.zoomOutControl.setDisplayName("Zoom Out");
        this.controls.add(this.zoomOutControl);
        Rectangle addWaypointArea = mobile ? MainGameScreen.btn(0.0f, 0.0f, false) : rightPaneLayout.buttonRect(4);
        this.addWaypointControl = new SolUiControl(addWaypointArea, true, gameOptions.getKeyShoot2());
        this.addWaypointControl.setDisplayName("Marker+");
        this.controls.add(this.addWaypointControl);
        Rectangle removeWaypointArea = mobile ? MainGameScreen.btn(0.0f, 0.17f, false) : rightPaneLayout.buttonRect(5);
        this.removeWaypointControl = new SolUiControl(removeWaypointArea, true, gameOptions.getKeyShoot2());
        this.removeWaypointControl.setDisplayName("Marker-");
        this.controls.add(this.removeWaypointControl);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        Boolean scrolledUp;
        float mapZoom;
        boolean zoomIn;
        SolGame game = solApplication.getGame();
        GameOptions gameOptions = solApplication.getOptions();
        boolean justClosed = this.closeControl.isJustOff();
        MapDrawer mapDrawer = game.getMapDrawer();
        mapDrawer.setToggled(!justClosed);
        SolInputManager im = solApplication.getInputManager();
        if (justClosed) {
            mapDrawer.getMapDrawPositionAdditive().set(0.0f, 0.0f);
            this.isPickingWaypointSpot = false;
            this.addWaypointControl.setDisplayName("Marker+");
            im.setScreen(solApplication, game.getScreens().mainGameScreen);
        }
        if ((zoomIn = this.zoomInControl.isJustOff()) || this.zoomOutControl.isJustOff()) {
            mapDrawer.changeZoom(zoomIn);
        }
        this.zoomInControl.setEnabled((mapZoom = mapDrawer.getZoom()) != 8.0f);
        this.zoomOutControl.setEnabled(mapZoom != 512.0f);
        ShipUiControl shipControl = game.getScreens().mainGameScreen.shipControl;
        if (shipControl instanceof ShipMouseControl) {
            shipControl.update(solApplication, true);
        }
        if ((scrolledUp = im.getScrolledUp()) != null) {
            if (scrolledUp.booleanValue()) {
                this.zoomOutControl.maybeFlashPressed(gameOptions.getKeyZoomOut());
            } else {
                this.zoomInControl.maybeFlashPressed(gameOptions.getKeyZoomIn());
            }
        }
        if (im.touchDragged) {
            float scrollFactor = -mapDrawer.getZoom() / (float)Gdx.graphics.getHeight() * (float)gameOptions.getMapScrollSpeed();
            float rotateAngle = game.getCam().getAngle();
            mapDrawer.getMapDrawPositionAdditive().add(im.getDrag().scl(scrollFactor).rotate(rotateAngle));
        }
        if (this.isPickingWaypointSpot && inputPointers[0].isJustUnPressed() && !this.addWaypointControl.isJustOff()) {
            Vector2 mapCamPos = game.getCam().getPosition().add(mapDrawer.getMapDrawPositionAdditive());
            Vector2 clickPosition = new Vector2(inputPointers[0].x, inputPointers[0].y);
            Vector2 worldPosition = this.screenPositionToWorld(clickPosition, mapCamPos, mapZoom);
            ArrayList<Waypoint> waypoints = game.getHero().getWaypoints();
            boolean canCreate = true;
            for (int w = 0; w < waypoints.size(); ++w) {
                Waypoint waypoint = waypoints.get(w);
                if (!(worldPosition.x > waypoint.position.x - 5.0f) || !(worldPosition.x < waypoint.position.x + 5.0f) || !(worldPosition.y > waypoint.position.y - 5.0f) || !(worldPosition.y < waypoint.position.y + 5.0f)) continue;
                canCreate = false;
                break;
            }
            if (canCreate) {
                this.setWaypointButtonsEnabled(false);
                WaypointCreationScreen waypointCreationScreen = game.getScreens().waypointCreationScreen;
                waypointCreationScreen.setWaypointPos(worldPosition);
                solApplication.getInputManager().setScreen(solApplication, game.getScreens().mapScreen);
                solApplication.getInputManager().addScreen(solApplication, waypointCreationScreen);
            }
            this.addWaypointControl.setDisplayName("Marker+");
            this.isPickingWaypointSpot = false;
        }
        if (this.isPickingWaypointToRemove && inputPointers[0].isJustUnPressed() && !this.removeWaypointControl.isJustOff()) {
            Vector2 clickPosition = new Vector2(inputPointers[0].x, inputPointers[0].y);
            Vector2 realPosition = this.screenPositionToWorld(clickPosition, game.getCam().getPosition(), mapZoom);
            ArrayList<Waypoint> waypoints = game.getHero().getWaypoints();
            for (int w = 0; w < waypoints.size(); ++w) {
                Waypoint waypoint = waypoints.get(w);
                if (!(waypoint.position.x > realPosition.x - 5.0f) || !(waypoint.position.x < realPosition.x + 5.0f) || !(waypoint.position.y > realPosition.y - 5.0f) || !(waypoint.position.y < realPosition.y + 5.0f)) continue;
                game.getHero().removeWaypoint(waypoint);
                game.getObjectManager().removeObjDelayed(waypoint);
            }
            this.addWaypointControl.setEnabled(true);
            this.removeWaypointControl.setDisplayName("Marker-");
            this.isPickingWaypointToRemove = false;
        }
        if (this.addWaypointControl.isJustOff()) {
            if (this.isPickingWaypointSpot) {
                this.isPickingWaypointSpot = false;
                this.addWaypointControl.setDisplayName("Marker+");
                this.removeWaypointControl.setEnabled(true);
            } else {
                this.isPickingWaypointSpot = true;
                this.addWaypointControl.setDisplayName("Cancel");
                this.removeWaypointControl.setEnabled(false);
            }
        }
        if (this.removeWaypointControl.isJustOff()) {
            if (this.isPickingWaypointToRemove) {
                this.isPickingWaypointToRemove = false;
                this.removeWaypointControl.setDisplayName("Marker-");
                this.addWaypointControl.setEnabled(true);
            } else {
                this.isPickingWaypointToRemove = true;
                this.removeWaypointControl.setDisplayName("Cancel");
                this.addWaypointControl.setEnabled(false);
            }
        }
    }

    public Vector2 screenPositionToWorld(Vector2 screenPos, Vector2 camPos, float mapZoom) {
        float ratio = (float)Gdx.graphics.getWidth() / (float)Gdx.graphics.getHeight();
        screenPos.scl(5.0f);
        screenPos.scl(mapZoom);
        Vector2 finalPosition = new Vector2(camPos);
        finalPosition.add(screenPos);
        finalPosition.x -= ratio * mapZoom / 0.4f;
        finalPosition.y -= mapZoom / 0.4f;
        return finalPosition;
    }

    public void setWaypointButtonsEnabled(boolean value) {
        this.removeWaypointControl.setEnabled(value);
        this.addWaypointControl.setEnabled(value);
    }

    public boolean isPickingWaypointSpot() {
        return this.isPickingWaypointSpot;
    }

    public boolean isPickingWaypointToRemove() {
        return this.isPickingWaypointToRemove;
    }
}

