/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.SolGame;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class MenuScreen
extends SolUiBaseScreen {
    private final SolUiControl closeControl;
    private final SolUiControl exitControl;
    private final SolUiControl respawnControl;
    private final SolUiControl soundVolControl;
    private final SolUiControl musicVolumeControl;
    private final SolUiControl doNotSellEquippedControl;

    public MenuScreen(MenuLayout menuLayout, GameOptions gameOptions) {
        this.doNotSellEquippedControl = new SolUiControl(menuLayout.buttonRect(-1, -1), true, new int[0]);
        this.doNotSellEquippedControl.setDisplayName("Can sell used items");
        this.controls.add(this.doNotSellEquippedControl);
        this.soundVolControl = new SolUiControl(menuLayout.buttonRect(-1, 1), true, new int[0]);
        this.soundVolControl.setDisplayName("Sound Volume");
        this.controls.add(this.soundVolControl);
        this.musicVolumeControl = new SolUiControl(menuLayout.buttonRect(-1, 0), true, new int[0]);
        this.musicVolumeControl.setDisplayName("Music Volume");
        this.controls.add(this.musicVolumeControl);
        this.respawnControl = new SolUiControl(menuLayout.buttonRect(-1, 2), true, new int[0]);
        this.respawnControl.setDisplayName("Respawn");
        this.controls.add(this.respawnControl);
        this.exitControl = new SolUiControl(menuLayout.buttonRect(-1, 3), true, new int[0]);
        this.exitControl.setDisplayName("Exit");
        this.controls.add(this.exitControl);
        this.closeControl = new SolUiControl(menuLayout.buttonRect(-1, 4), true, gameOptions.getKeyClose());
        this.closeControl.setDisplayName("Resume");
        this.controls.add(this.closeControl);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        game.setPaused(true);
        SolInputManager im = solApplication.getInputManager();
        GameOptions options = solApplication.getOptions();
        this.soundVolControl.setDisplayName("Sound Volume: " + options.sfxVolume.getName());
        if (this.soundVolControl.isJustOff()) {
            options.advanceSoundVolMul();
        }
        this.musicVolumeControl.setDisplayName("Music Volume: " + options.musicVolume.getName());
        if (this.musicVolumeControl.isJustOff()) {
            options.advanceMusicVolMul();
            solApplication.getMusicManager().changeVolume(options);
        }
        if (this.respawnControl.isJustOff()) {
            game.respawn();
            im.setScreen(solApplication, game.getScreens().mainGameScreen);
            game.setPaused(false);
        }
        if (this.exitControl.isJustOff()) {
            solApplication.finishGame();
        }
        if (this.closeControl.isJustOff()) {
            game.setPaused(false);
            im.setScreen(solApplication, game.getScreens().mainGameScreen);
        }
        this.doNotSellEquippedControl.setDisplayName("Can sell used items: " + (options.canSellEquippedItems ? "Yes" : "No"));
        if (this.doNotSellEquippedControl.isJustOff()) {
            options.canSellEquippedItems = !options.canSellEquippedItems;
        }
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw(uiDrawer.filler, SolColor.UI_BG);
    }

    @Override
    public boolean isCursorOnBackground(SolInputManager.InputPointer inputPointer) {
        return true;
    }
}

