/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.screens.TalkScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class SellItems
extends InventoryOperationsScreen {
    private static float PERC = 0.8f;
    private final SolUiControl sellControl;

    SellItems(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.sellControl = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeySellItem());
        this.sellControl.setDisplayName("Sell");
        this.controls.add(this.sellControl);
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        Hero hero = game.getHero();
        return hero.isTranscendent() ? null : hero.getItemContainer();
    }

    @Override
    public boolean isUsing(SolGame game, SolItem item) {
        Hero hero = game.getHero();
        return hero.isNonTranscendent() && hero.maybeUnequip(game, item, false);
    }

    @Override
    public float getPriceMul() {
        return PERC;
    }

    @Override
    public String getHeader() {
        return "Sell:";
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        InventoryScreen inventoryScreen = game.getScreens().inventoryScreen;
        TalkScreen talkScreen = game.getScreens().talkScreen;
        SolShip target = talkScreen.getTarget();
        Hero hero = game.getHero();
        if (talkScreen.isTargetFar(hero)) {
            solApplication.getInputManager().setScreen(solApplication, game.getScreens().mainGameScreen);
            return;
        }
        SolItem selItem = inventoryScreen.getSelectedItem();
        if (selItem == null) {
            this.sellControl.setDisplayName("----");
            this.sellControl.setEnabled(false);
            return;
        }
        boolean isWornAndCanBeSold = this.isItemEquippedAndSellable(selItem, solApplication.getOptions());
        boolean enabled = this.isItemSellable(selItem, target);
        if (enabled && isWornAndCanBeSold) {
            this.sellControl.setDisplayName("Sell");
            this.sellControl.setEnabled(true);
        } else if (enabled) {
            this.sellControl.setDisplayName("Unequip it!");
            this.sellControl.setEnabled(false);
        } else {
            this.sellControl.setDisplayName("----");
            this.sellControl.setEnabled(false);
        }
        if (!enabled || !isWornAndCanBeSold) {
            return;
        }
        if (this.sellControl.isJustOff()) {
            ItemContainer itemContainer = hero.getItemContainer();
            inventoryScreen.setSelected(itemContainer.getSelectionAfterRemove(inventoryScreen.getSelected()));
            itemContainer.remove(selItem);
            target.getTradeContainer().getItems().add(selItem);
            hero.setMoney(hero.getMoney() + selItem.getPrice() * PERC);
        }
    }

    private boolean isItemSellable(SolItem item, SolShip target) {
        return target.getTradeContainer().getItems().canAdd(item);
    }

    private boolean isItemEquippedAndSellable(SolItem item, GameOptions options) {
        return item.isEquipped() == 0 || options.canSellEquippedItems;
    }
}

