/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.screens.ShipUiControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShipControllerControl
implements ShipUiControl {
    private static Logger logger = LoggerFactory.getLogger(ShipControllerControl.class);
    private boolean controllerShoot;
    private boolean controllerShoot2;
    private boolean controllerAbility;
    private boolean controllerLeft;
    private boolean controllerRight;
    private boolean controllerUp;
    private boolean controllerDown;

    ShipControllerControl(SolApplication solApplication) {
        final GameOptions gameOptions = solApplication.getOptions();
        Controllers.clearListeners();
        logger.debug("Controllers Size: {}", (Object)Controllers.getControllers().size);
        int i = 0;
        for (Controller controller : Controllers.getControllers()) {
            logger.debug("#{}:{}", (Object)i++, (Object)controller.getName());
        }
        Controllers.addListener((ControllerListener)new ControllerListener(){

            int indexOf(Controller controller) {
                return Controllers.getControllers().indexOf((Object)controller, true);
            }

            public void connected(Controller controller) {
            }

            public void disconnected(Controller controller) {
            }

            public boolean buttonDown(Controller controller, int buttonIndex) {
                if (buttonIndex == gameOptions.getControllerButtonShoot()) {
                    ShipControllerControl.this.controllerShoot = true;
                } else if (buttonIndex == gameOptions.getControllerButtonShoot2()) {
                    ShipControllerControl.this.controllerShoot2 = true;
                } else if (buttonIndex == gameOptions.getControllerButtonAbility()) {
                    ShipControllerControl.this.controllerAbility = true;
                } else if (buttonIndex == gameOptions.getControllerButtonLeft()) {
                    ShipControllerControl.this.controllerLeft = true;
                } else if (buttonIndex == gameOptions.getControllerButtonRight()) {
                    ShipControllerControl.this.controllerRight = true;
                } else if (buttonIndex == gameOptions.getControllerButtonUp()) {
                    ShipControllerControl.this.controllerUp = true;
                }
                return true;
            }

            public boolean buttonUp(Controller controller, int buttonIndex) {
                if (buttonIndex == gameOptions.getControllerButtonShoot()) {
                    ShipControllerControl.this.controllerShoot = false;
                } else if (buttonIndex == gameOptions.getControllerButtonShoot2()) {
                    ShipControllerControl.this.controllerShoot2 = false;
                } else if (buttonIndex == gameOptions.getControllerButtonAbility()) {
                    ShipControllerControl.this.controllerAbility = false;
                } else if (buttonIndex == gameOptions.getControllerButtonLeft()) {
                    ShipControllerControl.this.controllerLeft = false;
                } else if (buttonIndex == gameOptions.getControllerButtonRight()) {
                    ShipControllerControl.this.controllerRight = false;
                } else if (buttonIndex == gameOptions.getControllerButtonUp()) {
                    ShipControllerControl.this.controllerUp = false;
                }
                return true;
            }

            public boolean axisMoved(Controller controller, int axisIndex, float value) {
                if (axisIndex == gameOptions.getControllerAxisShoot()) {
                    ShipControllerControl.this.controllerShoot = value > 0.5f;
                } else if (axisIndex == gameOptions.getControllerAxisShoot2()) {
                    ShipControllerControl.this.controllerShoot2 = value > 0.5f;
                } else if (axisIndex == gameOptions.getControllerAxisAbility()) {
                    ShipControllerControl.this.controllerAbility = value > 0.5f;
                } else if (axisIndex == gameOptions.getControllerAxisLeftRight()) {
                    boolean invert = gameOptions.isControllerAxisLeftRightInverted();
                    if (value < -0.5f) {
                        ShipControllerControl.this.controllerLeft = !invert;
                        ShipControllerControl.this.controllerRight = invert;
                    } else if (value > 0.5f) {
                        ShipControllerControl.this.controllerLeft = invert;
                        ShipControllerControl.this.controllerRight = !invert;
                    } else {
                        ShipControllerControl.this.controllerLeft = false;
                        ShipControllerControl.this.controllerRight = false;
                    }
                } else if (axisIndex == gameOptions.getControllerAxisUpDown()) {
                    boolean invert = gameOptions.isControllerAxisUpDownInverted();
                    if (value < -0.5f) {
                        ShipControllerControl.this.controllerUp = !invert;
                        ShipControllerControl.this.controllerDown = invert;
                    } else if (value > 0.5f) {
                        ShipControllerControl.this.controllerUp = invert;
                        ShipControllerControl.this.controllerDown = !invert;
                    } else {
                        ShipControllerControl.this.controllerUp = false;
                        ShipControllerControl.this.controllerDown = false;
                    }
                }
                return true;
            }

            public boolean povMoved(Controller controller, int povIndex, PovDirection value) {
                logger.debug("#{}, pov {}: {}", new Object[]{this.indexOf(controller), povIndex, value});
                return false;
            }

            public boolean xSliderMoved(Controller controller, int sliderIndex, boolean value) {
                logger.debug("#{},  x slider  {}: {}", new Object[]{this.indexOf(controller), sliderIndex, value});
                return false;
            }

            public boolean ySliderMoved(Controller controller, int sliderIndex, boolean value) {
                logger.debug("#{},  y slider  {}: {}", new Object[]{this.indexOf(controller), sliderIndex, value});
                return false;
            }

            public boolean accelerometerMoved(Controller controller, int accelerometerIndex, Vector3 value) {
                return false;
            }
        });
    }

    @Override
    public boolean isLeft() {
        return this.controllerLeft;
    }

    @Override
    public boolean isRight() {
        return this.controllerRight;
    }

    @Override
    public boolean isUp() {
        return this.controllerUp;
    }

    @Override
    public boolean isDown() {
        return this.controllerDown;
    }

    @Override
    public boolean isShoot() {
        return this.controllerShoot;
    }

    @Override
    public boolean isShoot2() {
        return this.controllerShoot2;
    }

    @Override
    public boolean isAbility() {
        return this.controllerAbility;
    }
}

