/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.Hero;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.screens.MainGameScreen;
import org.destinationsol.game.screens.ShipUiControl;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolUiControl;

public class ShipKbControl
implements ShipUiControl {
    public final SolUiControl leftCtrl;
    public final SolUiControl rightCtrl;
    public final SolUiControl upCtrl;
    public final SolUiControl myDownCtrl;
    public final SolUiControl shootCtrl;
    public final SolUiControl shoot2Ctrl;
    public final SolUiControl abilityCtrl;

    ShipKbControl(SolApplication solApplication, List<SolUiControl> controls) {
        DisplayDimensions displayDimensions = SolApplication.displayDimensions;
        GameOptions gameOptions = solApplication.getOptions();
        boolean showButtons = solApplication.isMobile();
        float col0 = 0.0f;
        float col1 = col0 + 0.17f;
        float colN0 = displayDimensions.getRatio() - 0.17f;
        float colN1 = colN0 - 0.17f;
        float rowN0 = 0.83f;
        float rowN1 = rowN0 - 0.17f;
        this.leftCtrl = new SolUiControl(showButtons ? MainGameScreen.btn(colN1, rowN0, false) : null, false, gameOptions.getKeyLeft());
        this.leftCtrl.setDisplayName("Left");
        controls.add(this.leftCtrl);
        this.rightCtrl = new SolUiControl(showButtons ? MainGameScreen.btn(colN0, rowN0, false) : null, false, gameOptions.getKeyRight());
        this.rightCtrl.setDisplayName("Right");
        controls.add(this.rightCtrl);
        this.upCtrl = new SolUiControl(showButtons ? MainGameScreen.btn(col0, rowN0, false) : null, false, gameOptions.getKeyUp());
        this.upCtrl.setDisplayName("Fwd");
        controls.add(this.upCtrl);
        this.myDownCtrl = new SolUiControl(null, true, gameOptions.getKeyDown());
        controls.add(this.myDownCtrl);
        this.shootCtrl = new SolUiControl(showButtons ? MainGameScreen.btn(col0, rowN1, false) : null, false, gameOptions.getKeyShoot());
        this.shootCtrl.setDisplayName("Gun 1");
        controls.add(this.shootCtrl);
        this.shoot2Ctrl = new SolUiControl(showButtons ? MainGameScreen.btn(col1, rowN0, false) : null, false, gameOptions.getKeyShoot2());
        this.shoot2Ctrl.setDisplayName("Gun 2");
        controls.add(this.shoot2Ctrl);
        this.abilityCtrl = new SolUiControl(showButtons ? MainGameScreen.btn(colN0, rowN1, false) : null, false, gameOptions.getKeyAbility());
        this.abilityCtrl.setDisplayName("Ability");
        controls.add(this.abilityCtrl);
    }

    @Override
    public void update(SolApplication solApplication, boolean enabled) {
        if (!enabled) {
            this.upCtrl.setEnabled(false);
            this.leftCtrl.setEnabled(false);
            this.rightCtrl.setEnabled(false);
            this.shootCtrl.setEnabled(false);
            this.shoot2Ctrl.setEnabled(false);
            this.abilityCtrl.setEnabled(false);
            return;
        }
        Hero hero = solApplication.getGame().getHero();
        boolean hasEngine = hero.isNonTranscendent() && hero.getHull().getEngine() != null;
        this.upCtrl.setEnabled(hasEngine);
        this.leftCtrl.setEnabled(hasEngine);
        this.rightCtrl.setEnabled(hasEngine);
        Gun g1 = hero.isTranscendent() ? null : hero.getHull().getGun(false);
        this.shootCtrl.setEnabled(g1 != null && g1.ammo > 0);
        Gun g2 = hero.isTranscendent() ? null : hero.getHull().getGun(true);
        this.shoot2Ctrl.setEnabled(g2 != null && g2.ammo > 0);
        this.abilityCtrl.setEnabled(hero.isNonTranscendent() && hero.canUseAbility());
    }

    @Override
    public boolean isLeft() {
        return this.leftCtrl.isOn();
    }

    @Override
    public boolean isRight() {
        return this.rightCtrl.isOn();
    }

    @Override
    public boolean isUp() {
        return this.upCtrl.isOn();
    }

    @Override
    public boolean isDown() {
        return this.myDownCtrl.isOn();
    }

    @Override
    public boolean isShoot() {
        return this.shootCtrl.isOn();
    }

    @Override
    public boolean isShoot2() {
        return this.shoot2Ctrl.isOn();
    }

    @Override
    public boolean isAbility() {
        return this.abilityCtrl.isOn();
    }
}

