/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.Mover;
import org.destinationsol.game.screens.ShipUiControl;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class ShipMixedControl
implements ShipUiControl {
    public final SolUiControl upCtrl;
    public final SolUiControl shootCtrl;
    public final SolUiControl shoot2Ctrl;
    public final SolUiControl abilityCtrl;
    private final SolUiControl myDownCtrl;
    private final Vector2 mouseWorldPosition;
    private final TextureAtlas.AtlasRegion myCursor;
    private boolean turnRight;
    private boolean turnLeft;

    ShipMixedControl(SolApplication solApplication, List<SolUiControl> controls) {
        GameOptions gameOptions = solApplication.getOptions();
        this.myCursor = Assets.getAtlasRegion("engine:uiCursorTarget");
        this.mouseWorldPosition = new Vector2();
        this.upCtrl = new SolUiControl(null, false, gameOptions.getKeyUpMouse());
        controls.add(this.upCtrl);
        this.myDownCtrl = new SolUiControl(null, false, gameOptions.getKeyDownMouse());
        controls.add(this.myDownCtrl);
        this.shootCtrl = new SolUiControl(null, false, gameOptions.getKeyShoot());
        controls.add(this.shootCtrl);
        this.shoot2Ctrl = new SolUiControl(null, false, gameOptions.getKeyShoot2());
        controls.add(this.shoot2Ctrl);
        this.abilityCtrl = new SolUiControl(null, false, gameOptions.getKeyAbility());
        controls.add(this.abilityCtrl);
    }

    @Override
    public void update(SolApplication solApplication, boolean enabled) {
        GameOptions gameOptions = solApplication.getOptions();
        this.blur();
        SolGame game = solApplication.getGame();
        if (!enabled || this.problemWithProjections(game.getCam())) {
            return;
        }
        SolInputManager im = solApplication.getInputManager();
        Hero hero = game.getHero();
        if (hero.isNonTranscendent()) {
            this.mouseWorldPosition.set((float)Gdx.input.getX(), (float)Gdx.input.getY());
            game.getCam().screenToWorld(this.mouseWorldPosition);
            SolMath.assetReal(this.mouseWorldPosition, hero.getPosition());
            float desiredAngle = SolMath.angle(hero.getPosition(), this.mouseWorldPosition);
            Boolean needsToTurn = Mover.needsToTurn(hero.getAngle(), desiredAngle, hero.getRotationSpeed(), hero.getRotationAcceleration(), 2.0f);
            if (needsToTurn != null) {
                if (needsToTurn.booleanValue()) {
                    this.turnRight = true;
                } else {
                    this.turnLeft = true;
                }
            }
            if (!im.isMouseOnUi()) {
                if (Gdx.input.isButtonPressed(0)) {
                    this.shootCtrl.maybeFlashPressed(gameOptions.getKeyShoot());
                }
                if (Gdx.input.isButtonPressed(1)) {
                    this.shoot2Ctrl.maybeFlashPressed(gameOptions.getKeyShoot2());
                }
                if (Gdx.input.isButtonPressed(2)) {
                    this.abilityCtrl.maybeFlashPressed(gameOptions.getKeyAbility());
                }
            }
        }
    }

    private boolean problemWithProjections(SolCam camera) {
        return Gdx.graphics.getWidth() == 0 || Gdx.graphics.getHeight() == 0 || camera.getViewWidth() <= 0.0f || camera.getViewHeight() <= 0.0f || !camera.isMatrixValid();
    }

    @Override
    public boolean isLeft() {
        return this.turnLeft;
    }

    @Override
    public boolean isRight() {
        return this.turnRight;
    }

    @Override
    public boolean isUp() {
        return this.upCtrl.isOn();
    }

    @Override
    public boolean isDown() {
        return this.myDownCtrl.isOn();
    }

    @Override
    public boolean isShoot() {
        return this.shootCtrl.isOn();
    }

    @Override
    public boolean isShoot2() {
        return this.shoot2Ctrl.isOn();
    }

    @Override
    public boolean isAbility() {
        return this.abilityCtrl.isOn();
    }

    @Override
    public TextureAtlas.AtlasRegion getInGameTex() {
        return this.myCursor;
    }

    @Override
    public void blur() {
        this.turnLeft = false;
        this.turnRight = false;
    }
}

