/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.game.BeaconHandler;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.screens.ShipUiControl;
import org.destinationsol.ui.SolInputManager;

public class ShipMouseControl
implements ShipUiControl {
    private final TextureAtlas.AtlasRegion myMoveCursor = Assets.getAtlasRegion("engine:uiCursorMove");
    private final TextureAtlas.AtlasRegion myAttackCursor = Assets.getAtlasRegion("engine:uiCursorAttack");
    private final TextureAtlas.AtlasRegion myFollowCursor = Assets.getAtlasRegion("engine:uiCursorFollow");
    private final Vector2 myMouseWorldPos = new Vector2();
    private TextureAtlas.AtlasRegion myCursor;

    ShipMouseControl() {
    }

    @Override
    public void update(SolApplication solApplication, boolean enabled) {
        SolGame game = solApplication.getGame();
        Hero hero = game.getHero();
        this.myCursor = null;
        if (hero.isNonTranscendent()) {
            this.myMouseWorldPos.set((float)Gdx.input.getX(), (float)Gdx.input.getY());
            game.getCam().screenToWorld(this.myMouseWorldPos);
            SolInputManager im = solApplication.getInputManager();
            boolean clicked = im.getPtrs()[0].pressed;
            boolean onMap = im.isScreenOn(game.getScreens().mapScreen);
            BeaconHandler.Action a = game.getBeaconHandler().processMouse(game, this.myMouseWorldPos, clicked, onMap);
            this.myCursor = a == BeaconHandler.Action.ATTACK ? this.myAttackCursor : (a == BeaconHandler.Action.FOLLOW ? this.myFollowCursor : this.myMoveCursor);
        }
    }

    @Override
    public boolean isLeft() {
        return false;
    }

    @Override
    public boolean isRight() {
        return false;
    }

    @Override
    public boolean isUp() {
        return false;
    }

    @Override
    public boolean isDown() {
        return false;
    }

    @Override
    public boolean isShoot() {
        return false;
    }

    @Override
    public boolean isShoot2() {
        return false;
    }

    @Override
    public boolean isAbility() {
        return false;
    }

    @Override
    public TextureAtlas.AtlasRegion getInGameTex() {
        return this.myCursor;
    }
}

