/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class ShowInventory
extends InventoryOperationsScreen {
    public final SolUiControl eq1Control;
    private final SolUiControl eq2Control;
    public final SolUiControl dropControl;
    private SolShip target;

    ShowInventory(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.eq1Control = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeyEquip());
        this.eq1Control.setDisplayName("Eq");
        this.controls.add(this.eq1Control);
        this.eq2Control = new SolUiControl(inventoryScreen.itemCtrl(1), true, gameOptions.getKeyEquip2());
        this.eq2Control.setDisplayName("Eq2");
        this.controls.add(this.eq2Control);
        this.dropControl = new SolUiControl(inventoryScreen.itemCtrl(2), true, gameOptions.getKeyDrop());
        this.dropControl.setDisplayName("Drop");
        this.controls.add(this.dropControl);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        InventoryScreen inventoryScreen = game.getScreens().inventoryScreen;
        SolItem selItem = inventoryScreen.getSelectedItem();
        this.eq1Control.setDisplayName("---");
        this.eq1Control.setEnabled(false);
        this.eq2Control.setDisplayName("---");
        this.eq2Control.setEnabled(false);
        this.dropControl.setEnabled(false);
        if (selItem == null || this.target == null) {
            return;
        }
        this.dropControl.setEnabled(true);
        if (this.dropControl.isJustOff()) {
            ItemContainer itemContainer = this.target.getItemContainer();
            inventoryScreen.setSelected(itemContainer.getSelectionAfterRemove(inventoryScreen.getSelected()));
            this.target.dropItem(solApplication.getGame(), selItem);
            return;
        }
        Boolean equipped1 = this.target.maybeUnequip(game, selItem, false, false);
        boolean canEquip1 = this.target.maybeEquip(game, selItem, false, false);
        Boolean equipped2 = this.target.maybeUnequip(game, selItem, true, false);
        boolean canEquip2 = this.target.maybeEquip(game, selItem, true, false);
        if (equipped1.booleanValue() || canEquip1) {
            this.eq1Control.setDisplayName(equipped1 != false ? "Unequip" : "Equip");
            this.eq1Control.setEnabled(true);
        }
        if (equipped2.booleanValue() || canEquip2) {
            this.eq2Control.setDisplayName(equipped2 != false ? "Unequip" : "Set Gun 2");
            this.eq2Control.setEnabled(true);
        }
        if (this.eq1Control.isJustOff()) {
            if (equipped1.booleanValue()) {
                this.target.maybeUnequip(game, selItem, false, true);
            } else {
                this.target.maybeEquip(game, selItem, false, true);
            }
        }
        if (this.eq2Control.isJustOff()) {
            if (equipped2.booleanValue()) {
                this.target.maybeUnequip(game, selItem, true, true);
            } else {
                this.target.maybeEquip(game, selItem, true, true);
            }
        }
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        return this.target == null ? null : this.target.getItemContainer();
    }

    @Override
    public boolean isUsing(SolGame game, SolItem item) {
        return this.target != null && this.target.maybeUnequip(game, item, false);
    }

    @Override
    public float getPriceMul() {
        return -1.0f;
    }

    @Override
    public String getHeader() {
        return "Items:";
    }

    public void setTarget(SolShip solship) {
        this.target = solship;
    }

    public SolShip getTarget() {
        return this.target;
    }
}

