/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class TakeItems
extends InventoryOperationsScreen {
    public final SolUiControl takeControl;
    private SolShip target;

    TakeItems(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.takeControl = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeyShoot());
        this.takeControl.setDisplayName("Take");
        this.controls.add(this.takeControl);
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        return this.target.getItemContainer();
    }

    @Override
    public String getHeader() {
        return "Take:";
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        InventoryScreen is = game.getScreens().inventoryScreen;
        Hero hero = game.getHero();
        SolItem selItem = is.getSelectedItem();
        boolean enabled = selItem != null && hero.getItemContainer().canAdd(selItem);
        this.takeControl.setDisplayName(enabled ? "Take" : "---");
        this.takeControl.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        if (this.takeControl.isJustOff()) {
            this.target.getItemContainer().remove(selItem);
            hero.getItemContainer().add(selItem);
        }
    }

    public void setTarget(SolShip solship) {
        this.target = solship;
    }
}

