/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.math.Rectangle;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class TalkScreen
extends SolUiBaseScreen {
    static final float MAX_TALK_DIST = 1.0f;
    public final SolUiControl buyControl;
    public final SolUiControl closeControl;
    private final SolUiControl sellControl;
    private final SolUiControl shipsControl;
    private final SolUiControl hireControl;
    private final Rectangle background;
    private SolShip target;

    TalkScreen(MenuLayout menuLayout, GameOptions gameOptions) {
        this.sellControl = new SolUiControl(menuLayout.buttonRect(-1, 0), true, gameOptions.getKeySellMenu());
        this.sellControl.setDisplayName("Sell");
        this.controls.add(this.sellControl);
        this.buyControl = new SolUiControl(menuLayout.buttonRect(-1, 1), true, gameOptions.getKeyBuyMenu());
        this.buyControl.setDisplayName("Buy");
        this.controls.add(this.buyControl);
        this.shipsControl = new SolUiControl(menuLayout.buttonRect(-1, 2), true, gameOptions.getKeyChangeShipMenu());
        this.shipsControl.setDisplayName("Change Ship");
        this.controls.add(this.shipsControl);
        this.hireControl = new SolUiControl(menuLayout.buttonRect(-1, 3), true, gameOptions.getKeyHireShipMenu());
        this.hireControl.setDisplayName("Hire");
        this.controls.add(this.hireControl);
        this.closeControl = new SolUiControl(menuLayout.buttonRect(-1, 4), true, gameOptions.getKeyClose());
        this.closeControl.setDisplayName("Close");
        this.controls.add(this.closeControl);
        this.background = menuLayout.background(-1, 0, 5);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        if (clickedOutside) {
            this.closeControl.maybeFlashPressed(solApplication.getOptions().getKeyClose());
            return;
        }
        SolGame game = solApplication.getGame();
        Hero hero = game.getHero();
        SolInputManager inputManager = solApplication.getInputManager();
        if (this.closeControl.isJustOff() || this.isTargetFar(hero)) {
            inputManager.setScreen(solApplication, game.getScreens().mainGameScreen);
            return;
        }
        boolean station = this.target.getHull().config.getType() == HullConfig.Type.STATION;
        this.shipsControl.setEnabled(station);
        this.hireControl.setEnabled(station);
        InventoryScreen inventoryScreen = game.getScreens().inventoryScreen;
        boolean sell = this.sellControl.isJustOff();
        boolean buy = this.buyControl.isJustOff();
        boolean sellShips = this.shipsControl.isJustOff();
        boolean hire = this.hireControl.isJustOff();
        if (sell || buy || sellShips || hire) {
            inventoryScreen.setOperations(sell ? inventoryScreen.sellItems : (buy ? inventoryScreen.buyItemsScreen : (sellShips ? inventoryScreen.changeShipScreen : inventoryScreen.hireShipsScreen)));
            inputManager.setScreen(solApplication, game.getScreens().mainGameScreen);
            inputManager.addScreen(solApplication, inventoryScreen);
        }
    }

    boolean isTargetFar(Hero hero) {
        if (hero.isTranscendent() || this.target == null || this.target.getLife() <= 0.0f) {
            return true;
        }
        float dst = this.target.getPosition().dst(hero.getPosition()) - hero.getHull().config.getApproxRadius() - this.target.getHull().config.getApproxRadius();
        return 1.0f < dst;
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw(this.background, SolColor.UI_BG);
    }

    @Override
    public boolean reactsToClickOutside() {
        return true;
    }

    @Override
    public boolean isCursorOnBackground(SolInputManager.InputPointer inputPointer) {
        return this.background.contains(inputPointer.x, inputPointer.y);
    }

    public SolShip getTarget() {
        return this.target;
    }

    public void setTarget(SolShip target) {
        this.target = target;
    }
}

