/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.UiDrawer;

public abstract class WarnDrawer {
    private static final float FADE_TIME = 1.0f;
    private final Color backgroundColor;
    private final Color textColor;
    private final float backgroundOriginA;
    private final String text;
    private final DisplayDimensions displayDimensions;
    private final List<Rectangle> rectangles = new ArrayList<Rectangle>();
    float drawPercentage;

    public WarnDrawer(String text) {
        this(text, SolColor.UI_WARN);
    }

    public WarnDrawer(String text, Color backgroundColor) {
        this.displayDimensions = SolApplication.displayDimensions;
        this.text = text;
        this.backgroundColor = new Color(backgroundColor);
        this.backgroundOriginA = backgroundColor.a;
        this.textColor = new Color(SolColor.WHITE);
        for (int i = 0; i < 3; ++i) {
            this.rectangles.add(this.createRectangle(i));
        }
    }

    public void update(SolGame game) {
        this.drawPercentage = this.shouldWarn(game) ? 1.0f : SolMath.approach(this.drawPercentage, 0.0f, 0.016666668f);
        this.backgroundColor.a = this.backgroundOriginA * this.drawPercentage;
        this.textColor.a = this.drawPercentage;
    }

    protected abstract boolean shouldWarn(SolGame var1);

    public void draw(UiDrawer uiDrawer, int drawIndex) {
        if (drawIndex >= this.rectangles.size()) {
            return;
        }
        uiDrawer.draw(this.rectangles.get(drawIndex), this.backgroundColor);
    }

    public void drawText(UiDrawer uiDrawer, int drawIndex) {
        if (drawIndex >= this.rectangles.size()) {
            return;
        }
        Rectangle warningRectangle = this.rectangles.get(drawIndex);
        uiDrawer.drawString(this.text, warningRectangle.x + warningRectangle.width / 2.0f, warningRectangle.y + warningRectangle.height / 2.0f, 1.0f, true, this.textColor);
    }

    private Rectangle createRectangle(int drawIndex) {
        float x;
        float y = 0.05f;
        switch (drawIndex) {
            case 1: {
                x = 0.18f * this.displayDimensions.getRatio();
                break;
            }
            case 2: {
                x = 0.62f * this.displayDimensions.getRatio();
                break;
            }
            default: {
                x = 0.4f * this.displayDimensions.getRatio();
            }
        }
        return new Rectangle(x, y, 0.2f * this.displayDimensions.getRatio(), 0.1f);
    }
}

