/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.screens.MapScreen;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.SolUiSlider;
import org.destinationsol.ui.UiDrawer;
import org.destinationsol.ui.Waypoint;

public class WaypointCreationScreen
extends SolUiBaseScreen {
    private final SolUiControl cancelControl;
    private final SolUiControl doneControl;
    private final MapScreen mapScreen;
    private Vector2 waypointPos;
    private final Rectangle previewRect;
    private final Rectangle background;
    private final SolUiSlider sliderRed;
    private final SolUiSlider sliderGreen;
    private final SolUiSlider sliderBlue;
    private Color outcomeColor;

    public WaypointCreationScreen(MenuLayout menuLayout, GameOptions gameOptions, MapScreen mapScreen) {
        this.mapScreen = mapScreen;
        this.doneControl = new SolUiControl(menuLayout.buttonRect(-1, 3), true, gameOptions.getKeyShoot());
        this.doneControl.setDisplayName("Done");
        this.controls.add(this.doneControl);
        this.cancelControl = new SolUiControl(menuLayout.buttonRect(-1, 4), true, gameOptions.getKeyClose());
        this.cancelControl.setDisplayName("Cancel");
        this.controls.add(this.cancelControl);
        this.previewRect = menuLayout.buttonRect(-1, -1);
        this.outcomeColor = Color.BLACK.cpy();
        this.sliderRed = new SolUiSlider(menuLayout.buttonRect(-1, 0), "Red: ", 1.0f, 2);
        this.sliderGreen = new SolUiSlider(menuLayout.buttonRect(-1, 1), "Green: ", 1.0f, 2);
        this.sliderBlue = new SolUiSlider(menuLayout.buttonRect(-1, 2), "Blue:", 1.0f, 2);
        this.background = menuLayout.background(-1, -1, 6);
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        this.sliderRed.setValue(1.0f);
        this.sliderGreen.setValue(1.0f);
        this.sliderBlue.setValue(1.0f);
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw(this.background, SolColor.UI_BG);
    }

    @Override
    public void drawImages(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw(this.previewRect, this.outcomeColor);
        this.sliderRed.draw(uiDrawer);
        this.sliderGreen.draw(uiDrawer);
        this.sliderBlue.draw(uiDrawer);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        if (this.doneControl.isJustOff()) {
            Waypoint waypoint = new Waypoint(this.waypointPos, this.outcomeColor, solApplication.getGame().getMapDrawer().getWaypointTexture());
            solApplication.getGame().getHero().addWaypoint(waypoint);
            solApplication.getGame().getObjectManager().addObjDelayed(waypoint);
            solApplication.getInputManager().setScreen(solApplication, solApplication.getGame().getScreens().mapScreen);
            this.mapScreen.setWaypointButtonsEnabled(true);
        }
        if (this.cancelControl.isJustOff()) {
            solApplication.getInputManager().setScreen(solApplication, solApplication.getGame().getScreens().mapScreen);
            this.mapScreen.setWaypointButtonsEnabled(true);
        }
        if (inputPointers[0].pressed) {
            Vector2 clickPos = new Vector2(inputPointers[0].x, inputPointers[0].y);
            this.sliderRed.click(clickPos);
            this.sliderGreen.click(clickPos);
            this.sliderBlue.click(clickPos);
        }
        this.outcomeColor.r = this.sliderRed.getValue();
        this.outcomeColor.g = this.sliderGreen.getValue();
        this.outcomeColor.b = this.sliderBlue.getValue();
    }

    public void setWaypointPos(Vector2 position) {
        this.outcomeColor = new Color();
        this.outcomeColor.a = 1.0f;
        this.waypointPos = position;
    }
}

