/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.SolApplication;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetManager;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.UiDrawer;

public class ZoneNameAnnouncer {
    private DisplayDimensions displayDimensions;
    private static final float FADE_TIME = 4.0f;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private String zone;
    private String text;

    ZoneNameAnnouncer() {
        this.displayDimensions = SolApplication.displayDimensions;
    }

    public void update(SolGame game) {
        PlanetManager planetManager = game.getPlanetManager();
        String zone = null;
        String pref = null;
        Vector2 camPosition = game.getCam().getPosition();
        Planet planet = planetManager.getNearestPlanet();
        if (planet.getPosition().dst(camPosition) < planet.getFullHeight()) {
            zone = planet.getName();
            pref = "Planet";
        } else {
            SolSystem system = planetManager.getNearestSystem(camPosition);
            if (system.getPosition().dst(camPosition) < system.getRadius()) {
                zone = system.getName();
                pref = "System";
            }
        }
        boolean reset = zone != null && !zone.equals(this.zone);
        this.zone = zone;
        if (reset) {
            this.color.a = 1.0f;
            this.text = pref + ":\n" + this.zone;
        } else if (this.color.a > 0.0f) {
            this.color.a -= 0.004166667f;
        }
    }

    public void drawText(UiDrawer uiDrawer) {
        if (this.color.a <= 0.0f) {
            return;
        }
        uiDrawer.drawString(this.text, this.displayDimensions.getRatio() / 2.0f, 0.15f, 1.5f, true, this.color);
    }
}

