/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJoint;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Faction;
import org.destinationsol.game.FactionManager;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.ship.SolShip;

public class Door {
    public static final float SPEED = 0.4f;
    public static final float SENSOR_DIST = 3.0f;
    public static final float DOOR_LEN = 1.1f;
    public static final float MAX_OPEN_AWAIT = 2.75f;
    private final PrismaticJoint myJoint;
    private final RectSprite myS;
    private float myOpenAwait;

    public Door(PrismaticJoint joint, RectSprite s) {
        this.myJoint = joint;
        this.myS = s;
    }

    public void update(SolGame game, SolShip ship) {
        boolean open;
        Vector2 doorPos = this.getBody().getPosition();
        boolean bl = open = this.myOpenAwait <= 0.0f && this.shouldOpen(game, ship, doorPos);
        if (open) {
            this.myOpenAwait = 2.75f;
            this.myJoint.setMotorSpeed(0.4f);
            game.getSoundManager().play(game, game.getSpecialSounds().doorMove, doorPos, ship);
        } else if (this.myOpenAwait > 0.0f) {
            this.myOpenAwait -= game.getTimeStep();
            if (this.myOpenAwait < 0.0f) {
                this.myJoint.setMotorSpeed(-0.4f);
                game.getSoundManager().play(game, game.getSpecialSounds().doorMove, doorPos, ship);
            }
        }
        Vector2 shipPos = ship.getPosition();
        float shipAngle = ship.getAngle();
        SolMath.toRel(doorPos, this.myS.getRelativePosition(), shipAngle, shipPos);
    }

    private boolean shouldOpen(SolGame game, SolShip ship, Vector2 doorPos) {
        Faction faction = ship.getPilot().getFaction();
        FactionManager factionManager = game.getFactionMan();
        List<SolObject> objs = game.getObjectManager().getObjects();
        for (SolObject o : objs) {
            SolShip ship2;
            Pilot pilot2;
            if (o == ship || !(o instanceof SolShip) || !(pilot2 = (ship2 = (SolShip)o).getPilot()).isUp() || factionManager.areEnemies(pilot2.getFaction(), faction) || !(ship2.getPosition().dst(doorPos) < 3.0f)) continue;
            return true;
        }
        return false;
    }

    public void collectDras(ArrayList<Drawable> drawables) {
        drawables.add(this.myS);
    }

    public Body getBody() {
        return this.myJoint.getBodyB();
    }

    public void onRemove(SolGame game) {
        World w = game.getObjectManager().getWorld();
        Body doorBody = this.getBody();
        w.destroyJoint((Joint)this.myJoint);
        w.destroyBody(doorBody);
    }
}

