/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.KnockBack;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class EmWave
implements ShipAbility {
    private static final int MAX_RADIUS = 4;
    private final EmWaveConfig config;

    EmWave(EmWaveConfig config) {
        this.config = config;
    }

    @Override
    public AbilityConfig getConfig() {
        return this.config;
    }

    @Override
    public AbilityCommonConfig getCommonConfig() {
        return this.config.cc;
    }

    @Override
    public float getRadius() {
        return 4.0f;
    }

    @Override
    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        if (!tryToUse) {
            return false;
        }
        Vector2 ownerPos = owner.getPosition();
        for (SolObject o : game.getObjectManager().getObjects()) {
            Vector2 oPos;
            float dst;
            float perc;
            if (!(o instanceof SolShip) || o == owner) continue;
            SolShip oShip = (SolShip)o;
            if (!game.getFactionMan().areEnemies(oShip, owner) || (perc = KnockBack.getPerc(dst = (oPos = o.getPosition()).dst(ownerPos), 4.0f)) <= 0.0f) continue;
            float duration = perc * this.config.duration;
            oShip.disableControls(duration, game);
        }
        DSParticleEmitter src = new DSParticleEmitter(((EmWaveConfig)this.config).cc.effect, 4.0f, DrawableLevel.PART_BG_0, new Vector2(), true, game, ownerPos, Vector2.Zero, 0.0f);
        game.getPartMan().finish(game, src, ownerPos);
        return true;
    }

    public static class EmWaveConfig
    implements AbilityConfig {
        public final float rechargeTime;
        public final float duration;
        private final SolItem chargeExample;
        private final AbilityCommonConfig cc;

        public EmWaveConfig(float rechargeTime, SolItem chargeExample, float duration, AbilityCommonConfig cc) {
            this.rechargeTime = rechargeTime;
            this.chargeExample = chargeExample;
            this.duration = duration;
            this.cc = cc;
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float rechargeTime = (float)abNode.getDouble("rechargeTime");
            float duration = (float)abNode.getDouble("duration");
            SolItem chargeExample = itemManager.getExample("emWaveCharge");
            return new EmWaveConfig(rechargeTime, chargeExample, duration, cc);
        }

        @Override
        public ShipAbility build() {
            return new EmWave(this);
        }

        @Override
        public SolItem getChargeExample() {
            return this.chargeExample;
        }

        @Override
        public float getRechargeTime() {
            return this.rechargeTime;
        }

        @Override
        public void appendDesc(StringBuilder sb) {
            sb.append("?\n");
        }
    }
}

