/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.item.Armor;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.TradeContainer;
import org.destinationsol.game.ship.ShipRepairer;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class FarShip
implements FarObject {
    private final Vector2 position;
    private final Vector2 velocity;
    private final Shield shield;
    private final Armor armor;
    private final float rotationSpeed;
    private final Pilot pilot;
    private final ItemContainer container;
    private final HullConfig hullConfig;
    private final Gun gun1;
    private final Gun gun2;
    private final RemoveController removeController;
    private final Engine engine;
    private final TradeContainer tradeContainer;
    private float angle;
    private float life;
    private ShipRepairer repairer;
    private float money;
    private MercItem mercItem;
    private boolean isMerc;

    public FarShip(Vector2 position, Vector2 velocity, float angle, float rotationSpeed, Pilot pilot, ItemContainer container, HullConfig hullConfig, float life, Gun gun1, Gun gun2, RemoveController removeController, Engine engine, ShipRepairer repairer, float money, TradeContainer tradeContainer, Shield shield, Armor armor) {
        this.position = position;
        this.velocity = velocity;
        this.angle = angle;
        this.rotationSpeed = rotationSpeed;
        this.pilot = pilot;
        this.container = container;
        this.hullConfig = hullConfig;
        this.life = life;
        this.gun1 = gun1;
        this.gun2 = gun2;
        this.removeController = removeController;
        this.engine = engine;
        this.repairer = repairer;
        this.money = money;
        this.tradeContainer = tradeContainer;
        this.shield = shield;
        this.armor = armor;
        if (this.pilot.isPlayer()) {
            if (this.shield != null) {
                this.shield.setEquipped(1);
            }
            if (this.armor != null) {
                this.armor.setEquipped(1);
            }
            if (this.gun1 != null) {
                this.gun1.setEquipped(1);
            }
            if (this.gun2 != null) {
                this.gun2.setEquipped(2);
            }
        }
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return this.removeController != null && this.removeController.shouldRemove(this.position);
    }

    @Override
    public SolShip toObject(SolGame game) {
        SolShip ship = game.getShipBuilder().build(game, this.position, this.velocity, this.angle, this.rotationSpeed, this.pilot, this.container, this.hullConfig, this.life, this.gun1, this.gun2, this.removeController, this.engine, this.repairer, this.money, this.tradeContainer, this.shield, this.armor);
        if (this.isMerc) {
            ship.setMerc(this.mercItem);
        }
        return ship;
    }

    @Override
    public void update(SolGame game) {
        this.pilot.updateFar(game, this);
        if (this.tradeContainer != null) {
            this.tradeContainer.update(game);
        }
        if (this.repairer != null) {
            this.life += this.repairer.tryRepair(game, this.container, this.life, this.hullConfig);
        }
    }

    @Override
    public float getRadius() {
        return this.hullConfig.getApproxRadius();
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    public void setPos(Vector2 position) {
        this.position.set(position);
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public Pilot getPilot() {
        return this.pilot;
    }

    public HullConfig getHullConfig() {
        return this.hullConfig;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector2 velocity) {
        this.velocity.set(velocity);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Gun getGun(boolean secondary) {
        return secondary ? this.gun2 : this.gun1;
    }

    public Shield getShield() {
        return this.shield;
    }

    public Armor getArmor() {
        return this.armor;
    }

    public float getLife() {
        return this.life;
    }

    public boolean mountCanFix(boolean sec) {
        int slotNr = sec ? 1 : 0;
        return !this.hullConfig.getGunSlot(slotNr).allowsRotation();
    }

    public float getMoney() {
        return this.money;
    }

    public ItemContainer getIc() {
        return this.container;
    }

    public void setMerc(MercItem mercItem) {
        this.mercItem = mercItem;
        this.isMerc = true;
    }

    public MercItem getMerc() {
        return this.mercItem;
    }

    public boolean isMerc() {
        return this.isMerc;
    }
}

