/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Faction;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.SolShip;

public class ForceBeacon {
    public static final float MAX_PULL_DIST = 0.7f;
    private final Vector2 myRelPos;
    private final Vector2 myPrevPos;
    private final DSParticleEmitter myEffect;

    public ForceBeacon(SolGame game, Vector2 relPos, Vector2 basePos, Vector2 baseVelocity) {
        this.myRelPos = relPos;
        this.myEffect = game.getSpecialEffects().buildForceBeacon(0.6f, game, relPos, basePos, baseVelocity);
        this.myEffect.setWorking(true);
        this.myPrevPos = new Vector2();
    }

    public static SolShip pullShips(SolGame game, SolObject owner, Vector2 ownPos, Vector2 ownVelocity, Faction faction, float maxPullDist) {
        SolShip res = null;
        float minLen = Float.MAX_VALUE;
        List<SolObject> objs = game.getObjectManager().getObjects();
        for (SolObject o : objs) {
            SolShip ship;
            Pilot pilot;
            if (o == owner || !(o instanceof SolShip) || (pilot = (ship = (SolShip)o).getPilot()).isUp() || pilot.isLeft() || pilot.isRight() || game.getFactionMan().areEnemies(faction, pilot.getFaction())) continue;
            Vector2 toMe = SolMath.distVec(ship.getPosition(), ownPos);
            float toMeLen = toMe.len();
            if (toMeLen < maxPullDist) {
                if (toMeLen > 1.0f) {
                    toMe.scl(1.0f / toMeLen);
                }
                if (ownVelocity != null) {
                    toMe.add(ownVelocity);
                }
                ship.getHull().getBody().setLinearVelocity(toMe);
                game.getSoundManager().play(game, game.getSpecialSounds().forceBeaconWork, null, ship);
                if (toMeLen < minLen) {
                    res = ship;
                    minLen = toMeLen;
                }
            }
            SolMath.free(toMe);
        }
        return res;
    }

    public void collectDras(List<Drawable> drawables) {
        drawables.addAll(this.myEffect.getDrawables());
    }

    public void update(SolGame game, Vector2 basePos, float baseAngle, SolShip ship) {
        Vector2 position = SolMath.toWorld(this.myRelPos, baseAngle, basePos);
        Vector2 velocity = SolMath.distVec(this.myPrevPos, position).scl(1.0f / game.getTimeStep());
        Faction faction = ship.getPilot().getFaction();
        ForceBeacon.pullShips(game, ship, position, velocity, faction, 0.7f);
        SolMath.free(velocity);
        this.myPrevPos.set(position);
        SolMath.free(position);
    }
}

