/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class KnockBack
implements ShipAbility {
    private static final int MAX_RADIUS = 8;
    private final KnockBackConfig config;

    KnockBack(KnockBackConfig config) {
        this.config = config;
    }

    public static float getPerc(float dst, float radius) {
        if (radius < dst) {
            return 0.0f;
        }
        float rHalf = radius / 2.0f;
        if (dst < rHalf) {
            return 1.0f;
        }
        return 1.0f - (dst - rHalf) / rHalf;
    }

    @Override
    public AbilityConfig getConfig() {
        return this.config;
    }

    @Override
    public AbilityCommonConfig getCommonConfig() {
        return this.config.cc;
    }

    @Override
    public float getRadius() {
        return 8.0f;
    }

    @Override
    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        if (!tryToUse) {
            return false;
        }
        Vector2 ownerPos = owner.getPosition();
        for (SolObject o : game.getObjectManager().getObjects()) {
            float perc;
            Vector2 oPos;
            float dst;
            if (o == owner || !o.receivesGravity() || (dst = (oPos = o.getPosition()).dst(ownerPos)) == 0.0f || (perc = KnockBack.getPerc(dst, 8.0f)) <= 0.0f) continue;
            Vector2 toO = SolMath.distVec(ownerPos, oPos);
            float accLen = this.config.force * perc;
            toO.scl(accLen / dst);
            o.receiveForce(toO, game, false);
            SolMath.free(toO);
        }
        DSParticleEmitter src = new DSParticleEmitter(this.config.cc.effect, 8.0f, DrawableLevel.PART_BG_0, new Vector2(), true, game, ownerPos, Vector2.Zero, 0.0f);
        game.getPartMan().finish(game, src, ownerPos);
        return true;
    }

    public static class KnockBackConfig
    implements AbilityConfig {
        public final float rechargeTime;
        public final float force;
        public final AbilityCommonConfig cc;
        private final SolItem chargeExample;

        public KnockBackConfig(float rechargeTime, SolItem chargeExample, float force, AbilityCommonConfig cc) {
            this.rechargeTime = rechargeTime;
            this.chargeExample = chargeExample;
            this.force = force;
            this.cc = cc;
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float rechargeTime = (float)abNode.getDouble("rechargeTime");
            float force = (float)abNode.getDouble("force");
            SolItem chargeExample = itemManager.getExample("knockBackCharge");
            return new KnockBackConfig(rechargeTime, chargeExample, force, cc);
        }

        @Override
        public ShipAbility build() {
            return new KnockBack(this);
        }

        @Override
        public SolItem getChargeExample() {
            return this.chargeExample;
        }

        @Override
        public float getRechargeTime() {
            return this.rechargeTime;
        }

        @Override
        public void appendDesc(StringBuilder sb) {
            sb.append("?\n");
        }
    }
}

