/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJoint;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJointDef;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.Faction;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.gun.GunMount;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.item.Armor;
import org.destinationsol.game.item.Clip;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.TradeConfig;
import org.destinationsol.game.item.TradeContainer;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.ship.Door;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.ForceBeacon;
import org.destinationsol.game.ship.ShipRepairer;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.Hull;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.json.JSONObject;

public class ShipBuilder {
    public static final float SHIP_DENSITY = 3.0f;
    public static final float AVG_BATTLE_TIME = 30.0f;
    public static final float AVG_ALLY_LIFE_TIME = 75.0f;
    private final CollisionMeshLoader myCollisionMeshLoader = new CollisionMeshLoader();

    public FarShip buildNewFar(SolGame game, Vector2 position, Vector2 velocity, float angle, float rotationSpeed, Pilot pilot, String items, HullConfig hullConfig, RemoveController removeController, boolean hasRepairer, float money, TradeConfig tradeConfig, boolean giveAmmo) {
        if (velocity == null) {
            velocity = new Vector2();
        }
        ItemContainer itemContainer = new ItemContainer();
        game.getItemMan().fillContainer(itemContainer, items);
        Engine.Config ec = hullConfig.getEngineConfig();
        Engine ei = ec == null ? null : ec.exampleEngine.copy();
        TradeContainer tc = tradeConfig == null ? null : new TradeContainer(tradeConfig);
        Gun g1 = null;
        Gun g2 = null;
        Shield shield = null;
        Armor armor = null;
        if (pilot.isPlayer()) {
            for (List<SolItem> group : itemContainer) {
                for (SolItem i : group) {
                    if (i instanceof Shield && i.isEquipped() > 0) {
                        shield = (Shield)i;
                        continue;
                    }
                    if (i instanceof Armor && i.isEquipped() > 0) {
                        armor = (Armor)i;
                        continue;
                    }
                    if (!(i instanceof Gun)) continue;
                    Gun g = (Gun)i;
                    if (i.isEquipped() <= 0) continue;
                    int slot = i.isEquipped();
                    if (g1 == null && hullConfig.getGunSlot(0).allowsRotation() != g.config.fixed && slot == 1) {
                        g1 = g;
                        continue;
                    }
                    if (hullConfig.getNrOfGunSlots() > 1 && g2 == null && hullConfig.getGunSlot(1).allowsRotation() != g.config.fixed && slot == 2) {
                        g2 = g;
                    }
                    if (g1 == g || g2 == g) continue;
                    i.setEquipped(0);
                }
            }
        } else {
            for (List<SolItem> group : itemContainer) {
                for (SolItem i : group) {
                    if (i instanceof Shield) {
                        shield = (Shield)i;
                        continue;
                    }
                    if (i instanceof Armor) {
                        armor = (Armor)i;
                        continue;
                    }
                    if (!(i instanceof Gun)) continue;
                    Gun g = (Gun)i;
                    if (g1 == null && hullConfig.getGunSlot(0).allowsRotation() != g.config.fixed) {
                        g1 = g;
                        continue;
                    }
                    if (hullConfig.getNrOfGunSlots() <= 1 || g2 != null || hullConfig.getGunSlot(1).allowsRotation() == g.config.fixed) continue;
                    g2 = g;
                }
            }
        }
        if (giveAmmo) {
            this.addAbilityCharges(itemContainer, hullConfig, pilot);
            this.addAmmo(itemContainer, g1, pilot);
            this.addAmmo(itemContainer, g2, pilot);
        }
        return new FarShip(new Vector2(position), new Vector2(velocity), angle, rotationSpeed, pilot, itemContainer, hullConfig, hullConfig.getMaxLife(), g1, g2, removeController, ei, hasRepairer ? new ShipRepairer() : null, money, tc, shield, armor);
    }

    private void addAmmo(ItemContainer ic, Gun g, Pilot pilot) {
        if (g == null) {
            return;
        }
        Gun.Config gc = g.config;
        Clip.Config cc = gc.clipConf;
        if (cc.infinite) {
            return;
        }
        float clipUseTime = (float)cc.size * gc.timeBetweenShots + gc.reloadTime;
        float lifeTime = pilot.getFaction() == Faction.LAANI ? 75.0f : 30.0f;
        int count = 1 + (int)(lifeTime / clipUseTime) + SolRandom.randomInt(0, 2);
        for (int i = 0; i < count; ++i) {
            if (!ic.canAdd(cc.example)) continue;
            ic.add(cc.example.copy());
        }
    }

    private void addAbilityCharges(ItemContainer ic, HullConfig hc, Pilot pilot) {
        SolItem ex;
        if (hc.getAbility() != null && (ex = hc.getAbility().getChargeExample()) != null) {
            int count;
            if (pilot.isPlayer()) {
                count = 3;
            } else {
                float lifeTime = pilot.getFaction() == Faction.LAANI ? 75.0f : 30.0f;
                count = (int)(lifeTime / hc.getAbility().getRechargeTime() * SolRandom.randomFloat(0.3f, 1.0f));
            }
            for (int i = 0; i < count; ++i) {
                ic.add(ex.copy());
            }
        }
    }

    public SolShip build(SolGame game, Vector2 position, Vector2 velocity, float angle, float rotationSpeed, Pilot pilot, ItemContainer container, HullConfig hullConfig, float life, Gun gun1, Gun gun2, RemoveController removeController, Engine engine, ShipRepairer repairer, float money, TradeContainer tradeContainer, Shield shield, Armor armor) {
        GunMount gunMount1;
        GunMount gunMount0;
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        Hull hull = this.buildHull(game, position, velocity, angle, rotationSpeed, hullConfig, life, drawables);
        SolShip ship = new SolShip(game, pilot, hull, removeController, drawables, container, repairer, money, tradeContainer, shield, armor);
        hull.getBody().setUserData((Object)ship);
        for (Door door : hull.getDoors()) {
            door.getBody().setUserData((Object)ship);
        }
        hull.setParticleEmitters(game, ship);
        if (engine != null) {
            hull.setEngine(engine);
        }
        if (gun1 != null && (gunMount0 = hull.getGunMount(false)).isFixed() == gun1.config.fixed) {
            gunMount0.setGun(game, ship, gun1, hullConfig.getGunSlot(0).isUnderneathHull(), 1);
        }
        if (gun2 != null && (gunMount1 = hull.getGunMount(true)) != null && gunMount1.isFixed() == gun2.config.fixed) {
            gunMount1.setGun(game, ship, gun2, hullConfig.getGunSlot(1).isUnderneathHull(), 2);
        }
        return ship;
    }

    private Hull buildHull(SolGame game, Vector2 position, Vector2 velocity, float angle, float rotationSpeed, HullConfig hullConfig, float life, ArrayList<Drawable> drawables) {
        BodyDef.BodyType bodyType;
        String shipName = hullConfig.getInternalName();
        JSONObject rootNode = Validator.getValidatedJSON(shipName, "engine:schemaHullConfig");
        JSONObject rigidBodyNode = rootNode.getJSONObject("rigidBody");
        this.myCollisionMeshLoader.readRigidBody(rigidBodyNode, hullConfig);
        BodyDef.BodyType bodyType2 = bodyType = hullConfig.getType() == HullConfig.Type.STATION ? BodyDef.BodyType.KinematicBody : BodyDef.BodyType.DynamicBody;
        DrawableLevel level = hullConfig.getType() == HullConfig.Type.STD ? DrawableLevel.BODIES : (hullConfig.getType() == HullConfig.Type.BIG ? DrawableLevel.BIG_BODIES : DrawableLevel.STATIONS);
        Body body = this.myCollisionMeshLoader.getBodyAndSprite(game, hullConfig, hullConfig.getSize(), bodyType, position, angle, drawables, 3.0f, level, hullConfig.getTexture());
        Fixture shieldFixture = this.createShieldFixture(hullConfig, body);
        GunMount gunMount0 = new GunMount(hullConfig.getGunSlot(0));
        GunMount gunMount1 = hullConfig.getNrOfGunSlots() > 1 ? new GunMount(hullConfig.getGunSlot(1)) : null;
        ArrayList<LightSource> lCs = new ArrayList<LightSource>();
        for (Vector2 vector2 : hullConfig.getLightSourcePositions()) {
            LightSource lightSource = new LightSource(0.35f, true, 0.7f, vector2, game.getCols().hullLights);
            lightSource.collectDrawables(drawables);
            lCs.add(lightSource);
        }
        ArrayList<ForceBeacon> beacons = new ArrayList<ForceBeacon>();
        for (Vector2 vector2 : hullConfig.getForceBeaconPositions()) {
            ForceBeacon fb = new ForceBeacon(game, vector2, position, velocity);
            fb.collectDras(drawables);
            beacons.add(fb);
        }
        ArrayList<Door> arrayList = new ArrayList<Door>();
        for (Vector2 doorRelPos : hullConfig.getDoorPositions()) {
            Door door = this.createDoor(game, position, angle, body, doorRelPos);
            door.collectDras(drawables);
            arrayList.add(door);
        }
        Hull hull = new Hull(game, hullConfig, body, gunMount0, gunMount1, lCs, life, beacons, arrayList, shieldFixture);
        body.setLinearVelocity(velocity);
        body.setAngularVelocity(rotationSpeed * ((float)Math.PI / 180));
        return hull;
    }

    private Fixture createShieldFixture(HullConfig hullConfig, Body body) {
        CircleShape shieldShape = new CircleShape();
        shieldShape.setRadius(0.7f * hullConfig.getSize());
        FixtureDef shieldDef = new FixtureDef();
        shieldDef.shape = shieldShape;
        shieldDef.isSensor = true;
        Fixture shieldFixture = body.createFixture(shieldDef);
        shieldShape.dispose();
        return shieldFixture;
    }

    private Door createDoor(SolGame game, Vector2 position, float angle, Body body, Vector2 doorRelPos) {
        World w = game.getObjectManager().getWorld();
        TextureAtlas.AtlasRegion tex = Assets.getAtlasRegion("engine:door");
        PrismaticJoint joint = this.createDoorJoint(body, w, position, doorRelPos, angle);
        RectSprite s = SpriteManager.createSprite(tex.name, 1.1f, 0.0f, 0.0f, new Vector2(doorRelPos), DrawableLevel.BODIES, 0.0f, 0.0f, SolColor.WHITE, false);
        return new Door(joint, s);
    }

    private PrismaticJoint createDoorJoint(Body shipBody, World w, Vector2 shipPos, Vector2 doorRelPos, float shipAngle) {
        Body doorBody = this.createDoorBody(w, shipPos, doorRelPos, shipAngle);
        PrismaticJointDef jd = new PrismaticJointDef();
        jd.initialize(shipBody, doorBody, shipPos, Vector2.Zero);
        jd.localAxisA.set(1.0f, 0.0f);
        jd.collideConnected = false;
        jd.enableLimit = true;
        jd.enableMotor = true;
        jd.lowerTranslation = 0.0f;
        jd.upperTranslation = 1.1f;
        jd.maxMotorForce = 2.0f;
        return (PrismaticJoint)w.createJoint((JointDef)jd);
    }

    private Body createDoorBody(World world, Vector2 shipPos, Vector2 doorRelPos, float shipAngle) {
        BodyDef bd = new BodyDef();
        bd.type = BodyDef.BodyType.DynamicBody;
        bd.angle = shipAngle * ((float)Math.PI / 180);
        bd.angularDamping = 0.0f;
        bd.linearDamping = 0.0f;
        SolMath.toWorld(bd.position, doorRelPos, shipAngle, shipPos);
        Body body = world.createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(0.55f, 0.03f);
        body.createFixture((Shape)shape, 3.0f);
        shape.dispose();
        return body;
    }

    public Vector2 getOrigin(String name) {
        return this.myCollisionMeshLoader.getOrigin(name + ".png", 1.0f);
    }
}

