/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.ship.SolShip;

public class ShipEngine {
    public static final float MAX_RECOVER_ROT_SPD = 5.0f;
    public static final float RECOVER_MUL = 15.0f;
    public static final float RECOVER_AWAIT = 2.0f;
    private final Engine myItem;
    private float myRecoverAwait;

    public ShipEngine(Engine engine) {
        this.myItem = engine;
    }

    public void update(float angle, SolGame game, Pilot provider, Body body, Vector2 velocity, boolean controlsEnabled, float mass, SolShip ship) {
        boolean working = this.applyInput(game, angle, provider, body, velocity, controlsEnabled, mass);
        game.getPartMan().updateAllHullEmittersOfType(ship, "engine", working);
    }

    private boolean applyInput(SolGame cmp, float shipAngle, Pilot provider, Body body, Vector2 velocity, boolean controlsEnabled, float mass) {
        boolean canAccelerate = SolMath.canAccelerate(shipAngle, velocity);
        boolean working = controlsEnabled && provider.isUp() && canAccelerate;
        Engine e = this.myItem;
        if (working) {
            Vector2 v = SolMath.fromAl(shipAngle, mass * e.getAcceleration());
            body.applyForceToCenter(v, true);
            SolMath.free(v);
        }
        float ts = cmp.getTimeStep();
        float rotationSpeed = body.getAngularVelocity() * 57.295776f;
        float desiredRotationSpeed = 0.0f;
        float rotAcc = e.getRotationAcceleration();
        boolean l = controlsEnabled && provider.isLeft();
        boolean r = controlsEnabled && provider.isRight();
        float absRotationSpeed = SolMath.abs(rotationSpeed);
        if (absRotationSpeed < e.getMaxRotationSpeed() && l != r) {
            desiredRotationSpeed = (float)SolMath.toInt(r) * e.getMaxRotationSpeed();
            if (absRotationSpeed < 5.0f) {
                if (this.myRecoverAwait > 0.0f) {
                    this.myRecoverAwait -= ts;
                }
                if (this.myRecoverAwait <= 0.0f) {
                    rotAcc *= 15.0f;
                }
            }
        } else {
            this.myRecoverAwait = 2.0f;
        }
        body.setAngularVelocity((float)Math.PI / 180 * SolMath.approach(rotationSpeed, desiredRotationSpeed, rotAcc * ts));
        return working;
    }

    public Engine getItem() {
        return this.myItem;
    }
}

