/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.ship.hulls.HullConfig;

public class ShipRepairer {
    public static final float REPAIR_AWAIT = 2.0f;
    private static final float REPAIR_SPD = 5.0f;
    private float myRepairPoints;

    public float tryRepair(SolGame game, ItemContainer ic, float life, HullConfig config) {
        if (life == (float)config.getMaxLife()) {
            return 0.0f;
        }
        float ts = game.getTimeStep();
        if (this.myRepairPoints <= 0.0f && ic.tryConsumeItem(game.getItemMan().getRepairExample())) {
            this.myRepairPoints = 20.0f;
        }
        if (this.myRepairPoints > 0.0f && life < (float)config.getMaxLife()) {
            float inc = 5.0f * ts;
            if (this.myRepairPoints < inc) {
                inc = this.myRepairPoints;
            }
            this.myRepairPoints -= inc;
            return SolMath.approach(life, inc, config.getMaxLife());
        }
        return 0.0f;
    }

    public float getRepairPoints() {
        return this.myRepairPoints;
    }
}

