/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class SloMo
implements ShipAbility {
    private static final float SLO_MO_CHG_SPD = 0.03f;
    private final SloMoConfig config;
    private float factor;

    SloMo(SloMoConfig config) {
        this.config = config;
        this.factor = 1.0f;
    }

    @Override
    public AbilityConfig getConfig() {
        return this.config;
    }

    @Override
    public AbilityCommonConfig getCommonConfig() {
        return this.config.cc;
    }

    @Override
    public float getRadius() {
        return Float.MAX_VALUE;
    }

    @Override
    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        if (tryToUse) {
            this.factor = this.config.factor;
            Vector2 position = owner.getPosition();
            DSParticleEmitter src = new DSParticleEmitter(((SloMoConfig)this.config).cc.effect, -1.0f, DrawableLevel.PART_BG_0, new Vector2(), true, game, position, owner.getVelocity(), 0.0f);
            game.getPartMan().finish(game, src, position);
            return true;
        }
        float ts = game.getTimeStep();
        this.factor = SolMath.approach(this.factor, 1.0f, 0.03f * ts);
        return false;
    }

    public float getFactor() {
        return this.factor;
    }

    public static class SloMoConfig
    implements AbilityConfig {
        public final float factor;
        public final float rechargeTime;
        private final SolItem chargeExample;
        private final AbilityCommonConfig cc;

        public SloMoConfig(float factor, float rechargeTime, SolItem chargeExample, AbilityCommonConfig cc) {
            this.factor = factor;
            this.rechargeTime = rechargeTime;
            this.chargeExample = chargeExample;
            this.cc = cc;
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float factor = (float)abNode.getDouble("factor");
            float rechargeTime = (float)abNode.getDouble("rechargeTime");
            SolItem chargeExample = itemManager.getExample("sloMoCharge");
            return new SloMoConfig(factor, rechargeTime, chargeExample, cc);
        }

        @Override
        public ShipAbility build() {
            return new SloMo(this);
        }

        @Override
        public SolItem getChargeExample() {
            return this.chargeExample;
        }

        @Override
        public float getRechargeTime() {
            return this.rechargeTime;
        }

        @Override
        public void appendDesc(StringBuilder sb) {
            sb.append("Time slow down to ").append((int)(this.factor * 100.0f)).append("%\n");
        }
    }
}

