/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import java.util.List;
import java.util.Objects;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.assets.sound.SpecialSounds;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FactionInfo;
import org.destinationsol.game.Hero;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.gun.GunMount;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.item.Armor;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.Loot;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.MoneyItem;
import org.destinationsol.game.item.RepairItem;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.TradeContainer;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.ShipRepairer;
import org.destinationsol.game.ship.Teleport;
import org.destinationsol.game.ship.hulls.Hull;
import org.destinationsol.game.ship.hulls.HullConfig;

public class SolShip
implements SolObject {
    public static final float BASE_DUR_MOD = 0.3f;
    public static final float PULL_DIST = 2.0f;
    public static final float SMOKE_PERC = 0.6f;
    public static final float FIRE_PERC = 0.3f;
    public static final float MAX_FIRE_AWAIT = 1.0f;
    private static final int TRADE_AFTER = 3;
    private static final float ENERGY_DMG_FACTOR = 0.7f;
    private boolean colliding = false;
    private String factionName;
    private int factionID;
    private final Pilot myPilot;
    private final ItemContainer myItemContainer;
    private final TradeContainer myTradeContainer;
    private final Hull myHull;
    private final DSParticleEmitter mySmokeSrc;
    private final DSParticleEmitter myFireSrc;
    private final DSParticleEmitter myElectricitySrc;
    private final RemoveController myRemoveController;
    private final List<Drawable> myDrawables;
    private final ShipRepairer myRepairer;
    private final ShipAbility myAbility;
    private Shield myShield;
    private float myMoney;
    private float myIdleTime;
    private Armor myArmor;
    private float myFireAwait;
    private float myAbilityAwait;
    private float myControlEnableAwait;
    private MercItem mercItem;
    private boolean isMerc;

    public SolShip(SolGame game, Pilot pilot, Hull hull, RemoveController removeController, List<Drawable> drawables, ItemContainer container, ShipRepairer repairer, float money, TradeContainer tradeContainer, Shield shield, Armor armor) {
        this.myRemoveController = removeController;
        this.myDrawables = drawables;
        this.myPilot = pilot;
        this.myHull = hull;
        this.myItemContainer = container;
        this.myTradeContainer = tradeContainer;
        List<DSParticleEmitter> effs = game.getSpecialEffects().buildBodyEffs(this.myHull.config.getApproxRadius(), game, this.myHull.getPosition(), this.myHull.getVelocity());
        this.mySmokeSrc = effs.get(0);
        this.myFireSrc = effs.get(1);
        this.myElectricitySrc = effs.get(2);
        this.myDrawables.addAll(this.mySmokeSrc.getDrawables());
        this.myDrawables.addAll(this.myFireSrc.getDrawables());
        this.myDrawables.addAll(this.myElectricitySrc.getDrawables());
        this.myRepairer = repairer;
        this.myMoney = money;
        this.myShield = shield;
        this.myArmor = armor;
        AbilityConfig ac = this.myHull.config.getAbility();
        ShipAbility shipAbility = this.myAbility = ac == null ? null : ac.build();
        if (this.myAbility != null) {
            this.myAbilityAwait = this.myAbility.getConfig().getRechargeTime();
        }
        this.factionID = FactionInfo.getFactionID(this);
        this.factionName = FactionInfo.getFactionNames().get(this.factionID).toString();
    }

    @Override
    public Vector2 getPosition() {
        return this.myHull.getPosition();
    }

    @Override
    public FarShip toFarObject() {
        float rotationSpeed = this.myHull.getBody().getAngularVelocity() * 57.295776f;
        FarShip farShip = new FarShip(this.myHull.getPosition(), this.myHull.getVelocity(), this.myHull.getAngle(), rotationSpeed, this.myPilot, this.myItemContainer, this.myHull.config, this.myHull.life, this.myHull.getGun(false), this.myHull.getGun(true), this.myRemoveController, this.myHull.getEngine(), this.myRepairer, this.myMoney, this.myTradeContainer, this.myShield, this.myArmor);
        if (this.isMerc) {
            farShip.setMerc(this.mercItem);
        }
        return farShip;
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.myDrawables;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
        this.colliding = true;
        if (this.tryCollectLoot(other, game)) {
            ((Loot)other).pickedUp(game, this);
            return;
        }
        if (this.myHull.config.getType() != HullConfig.Type.STATION) {
            float dmg = absImpulse / this.myHull.getMass() / this.myHull.config.getDurability();
            this.receiveDmg((int)(dmg *= 0.3f), game, collPos, DmgType.CRASH);
        }
    }

    @Override
    public String toDebugString() {
        return this.myPilot.toDebugString();
    }

    @Override
    public Boolean isMetal() {
        return true;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    private boolean tryCollectLoot(SolObject obj, SolGame game) {
        if (!(obj instanceof Loot)) {
            return false;
        }
        if (!this.myPilot.collectsItems()) {
            return false;
        }
        Loot loot = (Loot)obj;
        if (loot.getOwner() == this) {
            return false;
        }
        SolItem i = loot.getItem();
        if (i == null) {
            return false;
        }
        i.setEquipped(0);
        if (i instanceof MoneyItem) {
            this.myMoney += i.getPrice();
            return true;
        }
        ItemContainer c = this.shouldTrade(i, game) ? this.myTradeContainer.getItems() : this.myItemContainer;
        boolean canAdd = c.canAdd(i);
        if (canAdd) {
            c.add(i);
            if (c != this.myItemContainer || Objects.equals(this.myPilot.getMapHint(), "Merc")) {
                // empty if block
            }
        }
        return canAdd;
    }

    private boolean shouldTrade(SolItem i, SolGame game) {
        if (this.myTradeContainer == null) {
            return false;
        }
        if (i instanceof RepairItem) {
            return this.myItemContainer.count(game.getItemMan().getRepairExample()) >= 3;
        }
        Gun g1 = this.myHull.getGun(false);
        if (g1 != null && g1.config.clipConf.example.isSame(i)) {
            return this.myItemContainer.count(g1.config.clipConf.example) >= 3;
        }
        Gun g2 = this.myHull.getGun(true);
        if (g2 != null && g2.config.clipConf.example.isSame(i)) {
            return this.myItemContainer.count(g2.config.clipConf.example) >= 3;
        }
        return true;
    }

    @Override
    public Vector2 getVelocity() {
        return this.myHull.getVelocity();
    }

    @Override
    public float getAngle() {
        return this.myHull.getAngle();
    }

    public float getAcceleration() {
        Engine engine = this.myHull.getEngine();
        return engine == null ? 0.0f : engine.getAcceleration();
    }

    @Override
    public void update(SolGame game) {
        SolShip nearestEnemy = game.getFactionMan().getNearestEnemy(game, this);
        this.myPilot.update(game, this, nearestEnemy);
        this.myHull.update(game, this.myItemContainer, this.myPilot, this, nearestEnemy);
        game.getPartMan().updateAllHullEmittersOfType(this, "collision", this.colliding);
        this.updateAbility(game);
        this.updateIdleTime(game);
        this.updateShield(game);
        if (!this.isMerc && FactionInfo.getDisposition().get(this.factionID) < -5) {
            this.getPilot().stringToFaction("ehar");
        } else {
            this.getPilot().stringToFaction("laani");
        }
        if (this.myArmor != null && !this.myItemContainer.contains(this.myArmor)) {
            this.myArmor = null;
        }
        if (this.myTradeContainer != null) {
            this.myTradeContainer.update(game);
        }
        if (this.isControlsEnabled() && this.myRepairer != null && this.myIdleTime > 2.0f) {
            this.myHull.life += this.myRepairer.tryRepair(game, this.myItemContainer, this.myHull.life, this.myHull.config);
        }
        float ts = game.getTimeStep();
        if (this.myFireAwait > 0.0f) {
            this.myFireAwait -= ts;
        }
        this.mySmokeSrc.setWorking(this.myFireAwait > 0.0f || this.myHull.life < 0.6f * (float)this.myHull.config.getMaxLife());
        boolean onFire = this.myFireAwait > 0.0f || this.myHull.life < 0.3f * (float)this.myHull.config.getMaxLife();
        this.myFireSrc.setWorking(onFire);
        if (onFire) {
            game.getSoundManager().play(game, game.getSpecialSounds().burning, null, this);
        }
        if (!this.isControlsEnabled()) {
            this.myControlEnableAwait -= ts;
            if (this.isControlsEnabled()) {
                game.getSoundManager().play(game, game.getSpecialSounds().controlEnabled, null, this);
            }
        }
        this.myElectricitySrc.setWorking(!this.isControlsEnabled());
        if (this.myAbility instanceof Teleport) {
            ((Teleport)this.myAbility).maybeTeleport(game, this);
        }
        this.colliding = false;
    }

    private void updateAbility(SolGame game) {
        boolean tryToUse;
        boolean used;
        if (this.myAbility == null) {
            return;
        }
        OggSoundManager soundManager = game.getSoundManager();
        SpecialSounds sounds = game.getSpecialSounds();
        if (this.myAbilityAwait > 0.0f) {
            this.myAbilityAwait -= game.getTimeStep();
            if (this.myAbilityAwait <= 0.0f) {
                soundManager.play(game, sounds.abilityRecharged, null, this);
            }
        }
        if (used = this.myAbility.update(game, this, tryToUse = this.isControlsEnabled() && this.myPilot.isAbility() && this.canUseAbility())) {
            SolItem example = this.myAbility.getConfig().getChargeExample();
            if (example != null) {
                this.myItemContainer.tryConsumeItem(example);
            }
            this.myAbilityAwait = this.myAbility.getConfig().getRechargeTime();
            AbilityCommonConfig cc = this.myAbility.getCommonConfig();
            soundManager.play(game, cc.activatedSound, null, this);
        }
        if (tryToUse && !used) {
            soundManager.play(game, sounds.abilityRefused, null, this);
        }
    }

    private void updateShield(SolGame game) {
        if (this.myShield != null) {
            if (this.myItemContainer.contains(this.myShield)) {
                this.myShield.update(game, this);
            } else {
                this.myShield = null;
            }
        }
    }

    private void updateIdleTime(SolGame game) {
        float ts = game.getTimeStep();
        this.myIdleTime = Pilot.Utils.isIdle(this.myPilot) ? (this.myIdleTime += ts) : 0.0f;
    }

    public boolean canUseAbility() {
        if (this.myAbility == null || this.myAbilityAwait > 0.0f) {
            return false;
        }
        SolItem example = this.myAbility.getConfig().getChargeExample();
        if (example == null) {
            return true;
        }
        return this.myItemContainer.count(example) > 0;
    }

    public float getPullDist() {
        return 2.0f + this.myHull.config.getApproxRadius();
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return this.myHull.life <= 0.0f || this.myRemoveController != null && this.myRemoveController.shouldRemove(this.myHull.getPosition());
    }

    @Override
    public void onRemove(SolGame game) {
        if (this.myHull.life <= 0.0f) {
            game.getShardBuilder().buildExplosionShards(game, this.myHull.getPosition(), this.myHull.getVelocity(), this.myHull.config.getSize());
            this.throwAllLoot(game);
        }
        this.myHull.onRemove(game);
        game.getPartMan().finish(game, this.mySmokeSrc, this.myHull.getPosition());
        game.getPartMan().finish(game, this.myFireSrc, this.myHull.getPosition());
    }

    private void throwAllLoot(SolGame game) {
        if (this.myPilot.isPlayer()) {
            game.setRespawnState();
        }
        for (List<SolItem> group : this.myItemContainer) {
            for (SolItem item : group) {
                float dropChance = this.maybeUnequip(game, item, false) ? 0.35f : 0.6f;
                if (!SolRandom.test(dropChance)) continue;
                this.throwLoot(game, item, true);
            }
        }
        if (this.myTradeContainer != null) {
            for (List<SolItem> group : this.myTradeContainer.getItems()) {
                for (SolItem item : group) {
                    if (!SolRandom.test(0.6f)) continue;
                    this.throwLoot(game, item, true);
                }
            }
        }
        float thrMoney = this.myMoney * SolRandom.randomFloat(0.2f, 1.0f);
        List<MoneyItem> moneyItems = game.getItemMan().moneyToItems(thrMoney, 60);
        for (MoneyItem mi : moneyItems) {
            this.throwLoot(game, mi, true);
        }
    }

    private void throwLoot(SolGame game, SolItem item, boolean onDeath) {
        float speed;
        float velocityAngle;
        Vector2 lootVelocity = new Vector2();
        Vector2 position = new Vector2();
        if (onDeath) {
            velocityAngle = SolRandom.randomFloat(180.0f);
            speed = SolRandom.randomFloat(0.0f, 0.2f);
            SolMath.fromAl(position, velocityAngle, SolRandom.randomFloat(this.myHull.config.getApproxRadius()));
        } else {
            velocityAngle = this.getAngle();
            speed = 1.0f;
            SolMath.fromAl(position, velocityAngle, this.myHull.config.getApproxRadius());
        }
        SolMath.fromAl(lootVelocity, velocityAngle, speed);
        lootVelocity.add(this.myHull.getVelocity());
        position.add(this.myHull.getPosition());
        Loot l = game.getLootBuilder().build(game, position, item, lootVelocity, 6, SolRandom.randomFloat(4.0f), this);
        game.getObjectManager().addObjDelayed(l);
        if (!onDeath) {
            game.getSoundManager().play(game, game.getSpecialSounds().lootThrow, position, this);
        }
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        Hero hero = game.getHero();
        if (dmg <= 0.0f || hero.isInvincible() && hero.getShip() == this) {
            return;
        }
        if (this.myShield != null && this.myShield.canAbsorb(dmgType)) {
            this.myShield.absorb(game, dmg, position, this, dmgType);
            return;
        }
        if (this.myArmor != null) {
            if (dmgType == DmgType.ENERGY) {
                dmg *= 0.7f;
            }
            dmg *= 1.0f - this.myArmor.getPerc();
        }
        this.getHitWith(dmg, game, position, dmgType);
    }

    public void receivePiercingDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        if (dmg <= 0.0f) {
            return;
        }
        this.getHitWith(dmg, game, position, dmgType);
    }

    private void getHitWith(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        this.playHitSound(game, position, dmgType);
        boolean wasAlive = this.myHull.life > 0.0f;
        this.myHull.life -= dmg;
        if (wasAlive && this.myHull.life <= 0.0f) {
            this.onDeath(game);
            Vector2 shipPos = this.getPosition();
            game.getSpecialEffects().explodeShip(game, shipPos, this.myHull.config.getSize());
            game.getSoundManager().play(game, game.getSpecialSounds().shipExplosion, null, this);
        }
        if (dmgType == DmgType.FIRE) {
            this.myFireAwait = 1.0f;
        }
    }

    private void onDeath(SolGame game) {
        MercItem merc = this.getMerc();
        if (merc != null) {
            game.getHero().getMercs().remove(merc);
        }
    }

    private void playHitSound(SolGame game, Vector2 position, DmgType dmgType) {
        if (this.myArmor != null) {
            game.getSoundManager().play(game, this.myArmor.getHitSound(dmgType), position, this);
        } else {
            game.getSpecialSounds().playHit(game, this, position, dmgType);
        }
    }

    @Override
    public boolean receivesGravity() {
        return true;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        Body body = this.myHull.getBody();
        if (acc) {
            force.scl(this.myHull.getMass());
        }
        body.applyForceToCenter(force, true);
    }

    public ItemContainer getItemContainer() {
        return this.myItemContainer;
    }

    public float getLife() {
        return this.myHull.life;
    }

    public Pilot getPilot() {
        return this.myPilot;
    }

    public float getRotationSpeed() {
        return this.myHull.getRotationSpeed();
    }

    public float getRotationAcceleration() {
        Engine e = this.myHull.getEngine();
        return e == null ? 0.0f : e.getRotationAcceleration();
    }

    public Hull getHull() {
        return this.myHull;
    }

    public float calcTimeToTurn(float destAngle) {
        float angle = this.myHull.getAngle();
        Engine e = this.myHull.getEngine();
        float ad = SolMath.angleDiff(angle, destAngle);
        return ad / e.getMaxRotationSpeed();
    }

    public boolean maybeEquip(SolGame game, SolItem item, boolean equip) {
        return this.maybeEquip(game, item, false, equip) || this.maybeEquip(game, item, true, equip);
    }

    public boolean maybeEquip(SolGame game, SolItem item, boolean secondarySlot, boolean equip) {
        if (!secondarySlot) {
            if (item instanceof Engine) {
                boolean ok;
                Gdx.app.log("SolShip", "maybeEquip called for an engine item, can't do that!");
                Engine ei = (Engine)item;
                boolean bl = ok = ei.isBig() == (this.myHull.config.getType() == HullConfig.Type.BIG);
                if (ok && equip) {
                    this.myHull.setEngine(ei);
                }
                return ok;
            }
            if (item instanceof Shield) {
                Shield shield = (Shield)item;
                if (equip) {
                    this.maybeUnequip(game, this.myShield, false, true);
                    this.myShield = shield;
                    this.myShield.setEquipped(1);
                }
                return true;
            }
            if (item instanceof Armor) {
                Armor armor = (Armor)item;
                if (equip) {
                    this.maybeUnequip(game, this.myArmor, false, true);
                    this.myArmor = armor;
                    this.myArmor.setEquipped(1);
                }
                return true;
            }
        }
        if (item instanceof Gun) {
            boolean canEquip;
            Gun gun = (Gun)item;
            GunMount mount = this.myHull.getGunMount(secondarySlot);
            boolean bl = canEquip = mount != null && gun.config.fixed == mount.isFixed();
            if (canEquip && equip) {
                GunMount anotherMount = this.myHull.getGunMount(!secondarySlot);
                if (anotherMount != null && anotherMount.getGun() == item) {
                    anotherMount.setGun(game, this, null, false, 0);
                }
                int slotNr = secondarySlot ? 1 : 0;
                boolean under = this.myHull.config.getGunSlot(slotNr).isUnderneathHull();
                mount.setGun(game, this, gun, under, slotNr + 1);
            }
            return canEquip;
        }
        return false;
    }

    public boolean maybeUnequip(SolGame game, SolItem item, boolean unequip) {
        return this.maybeUnequip(game, item, false, unequip) || this.maybeUnequip(game, item, true, unequip);
    }

    public boolean maybeUnequip(SolGame game, SolItem item, boolean secondarySlot, boolean unequip) {
        GunMount m;
        if (!secondarySlot) {
            if (this.myHull.getEngine() == item) {
                Gdx.app.log("SolShip", "maybeUnequip called for an engine item, can't do that!");
                if (unequip) {
                    this.myHull.setEngine(null);
                }
                return true;
            }
            if (this.myShield == item) {
                if (unequip && this.myShield != null) {
                    this.myShield.setEquipped(0);
                    this.myShield = null;
                }
                return true;
            }
            if (this.myArmor == item) {
                if (unequip && this.myArmor != null) {
                    this.myArmor.setEquipped(0);
                    this.myArmor = null;
                }
                return true;
            }
        }
        if ((m = this.myHull.getGunMount(secondarySlot)) != null && m.getGun() == item) {
            if (unequip) {
                m.setGun(game, this, null, false, 0);
            }
            return true;
        }
        return false;
    }

    public float getRepairPoints() {
        return this.myRepairer == null ? 0.0f : this.myRepairer.getRepairPoints();
    }

    public float getMoney() {
        return this.myMoney;
    }

    public void setMoney(float money) {
        this.myMoney = money;
    }

    public TradeContainer getTradeContainer() {
        return this.myTradeContainer;
    }

    public Shield getShield() {
        return this.myShield;
    }

    public Armor getArmor() {
        return this.myArmor;
    }

    public ShipAbility getAbility() {
        return this.myAbility;
    }

    public void disableControls(float duration, SolGame game) {
        if (this.myControlEnableAwait <= 0.0f) {
            game.getSoundManager().play(game, game.getSpecialSounds().controlDisabled, null, this);
        }
        this.myControlEnableAwait += duration;
    }

    public boolean isControlsEnabled() {
        return this.myControlEnableAwait <= 0.0f;
    }

    public void dropItem(SolGame game, SolItem item) {
        this.myItemContainer.remove(item);
        this.throwLoot(game, item, false);
    }

    public float getAbilityAwait() {
        return this.myAbilityAwait;
    }

    public void setMerc(MercItem mercItem) {
        this.mercItem = mercItem;
        this.isMerc = true;
    }

    public MercItem getMerc() {
        return this.mercItem;
    }

    public boolean isMerc() {
        return this.isMerc;
    }

    public String getFactionName() {
        return this.factionName;
    }

    public int getFactionID() {
        return this.factionID;
    }

    public void changeDisposition(int id) {
        FactionInfo.setDisposition(id, -1);
    }
}

