/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.Faction;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class Teleport
implements ShipAbility {
    private static final int MAX_RADIUS = 4;
    private final Vector2 newPos;
    private final TeleportConfig config;
    private boolean shouldTeleport;
    private float angle;

    public Teleport(TeleportConfig config) {
        this.config = config;
        this.newPos = new Vector2();
    }

    @Override
    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        this.shouldTeleport = false;
        if (!tryToUse) {
            return false;
        }
        Vector2 position = owner.getPosition();
        Faction faction = owner.getPilot().getFaction();
        SolShip ne = game.getFactionMan().getNearestEnemy(game, 4.0f, faction, position);
        if (ne == null) {
            return false;
        }
        Vector2 nePos = ne.getPosition();
        Planet np = game.getPlanetManager().getNearestPlanet();
        if (np.isNearGround(nePos)) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            this.newPos.set(position);
            this.newPos.sub(nePos);
            this.angle = this.config.angle * SolRandom.randomFloat(0.5f, 1.0f) * (float)SolMath.toInt(SolRandom.test(0.5f));
            SolMath.rotate(this.newPos, this.angle);
            this.newPos.add(nePos);
            if (!game.isPlaceEmpty(this.newPos, false)) continue;
            this.shouldTeleport = true;
            return true;
        }
        return false;
    }

    @Override
    public AbilityConfig getConfig() {
        return this.config;
    }

    @Override
    public AbilityCommonConfig getCommonConfig() {
        return this.config.cc;
    }

    @Override
    public float getRadius() {
        return 4.0f;
    }

    public void maybeTeleport(SolGame game, SolShip owner) {
        if (!this.shouldTeleport) {
            return;
        }
        TextureAtlas.AtlasRegion tex = Assets.getAtlasRegion("engine:teleportBlip");
        float blipSz = owner.getHull().config.getApproxRadius() * 3.0f;
        game.getPartMan().blip(game, owner.getPosition(), SolRandom.randomFloat(180.0f), blipSz, 1.0f, Vector2.Zero, tex);
        game.getPartMan().blip(game, this.newPos, SolRandom.randomFloat(180.0f), blipSz, 1.0f, Vector2.Zero, tex);
        float newAngle = owner.getAngle() + this.angle;
        Vector2 newVelocity = SolMath.getVec(owner.getVelocity());
        SolMath.rotate(newVelocity, this.angle);
        Body body = owner.getHull().getBody();
        body.setTransform(this.newPos, newAngle * ((float)Math.PI / 180));
        body.setLinearVelocity(newVelocity);
        SolMath.free(newVelocity);
    }

    public static class TeleportConfig
    implements AbilityConfig {
        private final float angle;
        private final SolItem chargeExample;
        private final float rechargeTime;
        private final AbilityCommonConfig cc;

        public TeleportConfig(float angle, SolItem chargeExample, float rechargeTime, AbilityCommonConfig cc) {
            this.angle = angle;
            this.chargeExample = chargeExample;
            this.rechargeTime = rechargeTime;
            this.cc = cc;
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float angle = (float)abNode.getDouble("angle");
            SolItem chargeExample = itemManager.getExample("teleportCharge");
            float rechargeTime = (float)abNode.getDouble("rechargeTime");
            return new TeleportConfig(angle, chargeExample, rechargeTime, cc);
        }

        @Override
        public ShipAbility build() {
            return new Teleport(this);
        }

        @Override
        public SolItem getChargeExample() {
            return this.chargeExample;
        }

        @Override
        public float getRechargeTime() {
            return this.rechargeTime;
        }

        @Override
        public void appendDesc(StringBuilder sb) {
            sb.append("Teleport around enemy");
        }
    }
}

