/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.KnockBack;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class UnShield
implements ShipAbility {
    private static final int MAX_RADIUS = 6;
    private final UnShieldConfig config;

    UnShield(UnShieldConfig config) {
        this.config = config;
    }

    @Override
    public AbilityConfig getConfig() {
        return this.config;
    }

    @Override
    public AbilityCommonConfig getCommonConfig() {
        return this.config.cc;
    }

    @Override
    public float getRadius() {
        return 6.0f;
    }

    @Override
    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        if (!tryToUse) {
            return false;
        }
        Vector2 ownerPos = owner.getPosition();
        for (SolObject o : game.getObjectManager().getObjects()) {
            Vector2 oPos;
            float dst;
            float perc;
            float shieldLife;
            SolShip oShip;
            Shield shield;
            if (!(o instanceof SolShip) || o == owner || (shield = (oShip = (SolShip)o).getShield()) == null || (shieldLife = shield.getLife()) <= 0.0f || !game.getFactionMan().areEnemies(oShip, owner) || (perc = KnockBack.getPerc(dst = (oPos = o.getPosition()).dst(ownerPos), 6.0f)) <= 0.0f) continue;
            float amount = perc * this.config.amount;
            if (shieldLife < amount) {
                amount = shieldLife;
            }
            oShip.receiveDmg(amount, game, ownerPos, DmgType.ENERGY);
        }
        DSParticleEmitter src = new DSParticleEmitter(((UnShieldConfig)this.config).cc.effect, 6.0f, DrawableLevel.PART_BG_0, new Vector2(), true, game, ownerPos, Vector2.Zero, 0.0f);
        game.getPartMan().finish(game, src, ownerPos);
        return true;
    }

    public static class UnShieldConfig
    implements AbilityConfig {
        public final float rechargeTime;
        public final float amount;
        private final SolItem chargeExample;
        private final AbilityCommonConfig cc;

        public UnShieldConfig(float rechargeTime, SolItem chargeExample, float amount, AbilityCommonConfig cc) {
            this.rechargeTime = rechargeTime;
            this.chargeExample = chargeExample;
            this.amount = amount;
            this.cc = cc;
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float rechargeTime = (float)abNode.getDouble("rechargeTime");
            float amount = (float)abNode.getDouble("amount");
            SolItem chargeExample = itemManager.getExample("unShieldCharge");
            return new UnShieldConfig(rechargeTime, chargeExample, amount, cc);
        }

        @Override
        public ShipAbility build() {
            return new UnShield(this);
        }

        @Override
        public SolItem getChargeExample() {
            return this.chargeExample;
        }

        @Override
        public float getRechargeTime() {
            return this.rechargeTime;
        }

        @Override
        public void appendDesc(StringBuilder sb) {
            sb.append("Deal ").append(SolMath.nice(this.amount)).append(" dmg to enemy shields\n");
        }
    }
}

