/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship.hulls;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Faction;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.gun.GunMount;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.planet.PlanetBind;
import org.destinationsol.game.ship.Door;
import org.destinationsol.game.ship.ForceBeacon;
import org.destinationsol.game.ship.ShipEngine;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class Hull {
    public final HullConfig config;
    private final Body body;
    private final GunMount gunMount1;
    private final GunMount gunMount2;
    private final List<LightSource> lightSources;
    private final Vector2 position;
    private final Vector2 velocity;
    private final ArrayList<ForceBeacon> beacons;
    private final PlanetBind planetBind;
    private final float mass;
    private final ArrayList<Door> doors;
    private final Fixture shieldFixture;
    public float life;
    private float angle;
    private float rotationSpeed;
    private ShipEngine engine;
    private List<DSParticleEmitter> particleEmitters;

    public Hull(SolGame game, HullConfig hullConfig, Body body, GunMount gunMount1, GunMount gunMount2, List<LightSource> lightSources, float life, ArrayList<ForceBeacon> forceBeacons, ArrayList<Door> doors, Fixture shieldFixture) {
        this.config = hullConfig;
        this.body = body;
        this.gunMount1 = gunMount1;
        this.gunMount2 = gunMount2;
        this.lightSources = lightSources;
        this.life = life;
        this.doors = doors;
        this.shieldFixture = shieldFixture;
        this.position = new Vector2();
        this.velocity = new Vector2();
        this.beacons = forceBeacons;
        this.mass = this.body.getMass();
        this.setParamsFromBody();
        this.planetBind = this.config.getType() == HullConfig.Type.STATION ? PlanetBind.tryBind(game, this.position, this.angle) : null;
        this.particleEmitters = new ArrayList<DSParticleEmitter>();
    }

    public Body getBody() {
        return this.body;
    }

    public GunMount getGunMount(boolean second) {
        return second ? this.gunMount2 : this.gunMount1;
    }

    public Gun getGun(boolean second) {
        GunMount mount = this.getGunMount(second);
        if (mount == null) {
            return null;
        }
        return mount.getGun();
    }

    public void update(SolGame game, ItemContainer container, Pilot provider, SolShip ship, SolShip nearestEnemy) {
        boolean controlsEnabled;
        this.setParamsFromBody();
        boolean bl = controlsEnabled = ship.isControlsEnabled() && !SolCam.DIRECT_CAM_CONTROL;
        if (this.engine != null) {
            this.engine.update(this.angle, game, provider, this.body, this.velocity, controlsEnabled, this.mass, ship);
        }
        Faction faction = ship.getPilot().getFaction();
        this.gunMount1.update(container, game, this.angle, ship, controlsEnabled && provider.isShoot(), nearestEnemy, faction);
        if (this.gunMount2 != null) {
            this.gunMount2.update(container, game, this.angle, ship, controlsEnabled && provider.isShoot2(), nearestEnemy, faction);
        }
        for (LightSource src : this.lightSources) {
            src.update(true, this.angle, game);
        }
        for (ForceBeacon b : this.beacons) {
            b.update(game, this.position, this.angle, ship);
        }
        for (Door door : this.doors) {
            door.update(game, ship);
        }
        if (this.planetBind != null) {
            Vector2 velocity = SolMath.getVec();
            this.planetBind.setDiff(velocity, this.position, true);
            float fps = 1.0f / game.getTimeStep();
            velocity.scl(fps);
            this.body.setLinearVelocity(velocity);
            SolMath.free(velocity);
            float angleDiff = this.planetBind.getDesiredAngle() - this.angle;
            this.body.setAngularVelocity(angleDiff * ((float)Math.PI / 180) * fps);
        }
        game.getPartMan().updateAllHullEmittersOfType(ship, "none", true);
    }

    private void setParamsFromBody() {
        this.position.set(this.body.getPosition());
        this.angle = this.body.getAngle() * 57.295776f;
        this.rotationSpeed = this.body.getAngularVelocity() * 57.295776f;
        this.velocity.set(this.body.getLinearVelocity());
    }

    public void onRemove(SolGame game) {
        for (Door door : this.doors) {
            door.onRemove(game);
        }
        this.body.getWorld().destroyBody(this.body);
        this.particleEmitters.forEach(pe -> pe.onRemove(game, this.position));
    }

    public void setEngine(Engine engine) {
        this.engine = new ShipEngine(engine);
    }

    public void setParticleEmitters(SolGame game, SolShip ship) {
        ArrayList<Drawable> particleEmitterDrawables;
        List<Drawable> drawables = ship.getDrawables();
        if (!this.particleEmitters.isEmpty()) {
            particleEmitterDrawables = new ArrayList<Drawable>();
            this.particleEmitters.forEach(pe -> particleEmitterDrawables.addAll(pe.getDrawables()));
            drawables.removeAll(particleEmitterDrawables);
            game.getDrawableManager().removeAll(particleEmitterDrawables);
            this.particleEmitters.clear();
        }
        this.config.getParticleEmitters().forEach(pes -> this.particleEmitters.add(new DSParticleEmitter(game, (DSParticleEmitter)pes, ship)));
        particleEmitterDrawables = new ArrayList();
        this.particleEmitters.forEach(pe -> particleEmitterDrawables.addAll(pe.getDrawables()));
        drawables.addAll(particleEmitterDrawables);
        game.getDrawableManager().addAll(particleEmitterDrawables);
    }

    public float getAngle() {
        return this.angle;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public Engine getEngine() {
        return this.engine == null ? null : this.engine.getItem();
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public ArrayList<Door> getDoors() {
        return this.doors;
    }

    public Fixture getShieldFixture() {
        return this.shieldFixture;
    }

    public float getMass() {
        return this.mass;
    }

    public HullConfig getHullConfig() {
        return this.config;
    }

    public List<DSParticleEmitter> getParticleEmitters() {
        return this.particleEmitters;
    }
}

