/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.ship.hulls;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.Immutable;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.hulls.GunSlot;

@Immutable
public class HullConfig {
    private final Data data;

    public HullConfig(Data configData) {
        this.data = new Data(configData);
    }

    private static List<Vector2> deepCopyOf(List<Vector2> src) {
        ArrayList<Vector2> returnList = new ArrayList<Vector2>(src.size());
        for (Vector2 vector : src) {
            returnList.add(new Vector2(vector));
        }
        return returnList;
    }

    public String getInternalName() {
        return this.data.internalName;
    }

    public float getSize() {
        return this.data.size;
    }

    public int getMaxLife() {
        return this.data.maxLife;
    }

    public GunSlot getGunSlot(int slotNr) {
        return this.data.gunSlots.get(slotNr);
    }

    public int getNrOfGunSlots() {
        return this.data.gunSlots.size();
    }

    public List<GunSlot> getGunSlotList() {
        return new ArrayList<GunSlot>(this.data.gunSlots);
    }

    public List<DSParticleEmitter> getParticleEmitters() {
        return new ArrayList<DSParticleEmitter>(this.data.particleEmitters);
    }

    public List<Vector2> getLightSourcePositions() {
        return HullConfig.deepCopyOf(this.data.lightSrcPoss);
    }

    public float getDurability() {
        return this.data.durability;
    }

    public List<Vector2> getForceBeaconPositions() {
        return HullConfig.deepCopyOf(this.data.forceBeaconPoss);
    }

    public List<Vector2> getDoorPositions() {
        return HullConfig.deepCopyOf(this.data.doorPoss);
    }

    public TextureAtlas.AtlasRegion getIcon() {
        return new TextureAtlas.AtlasRegion(this.data.icon);
    }

    public Type getType() {
        return this.data.type;
    }

    public TextureAtlas.AtlasRegion getTexture() {
        return new TextureAtlas.AtlasRegion(this.data.tex);
    }

    public Engine.Config getEngineConfig() {
        return this.data.engineConfig;
    }

    public AbilityConfig getAbility() {
        return this.data.ability;
    }

    public float getApproxRadius() {
        return this.data.approxRadius;
    }

    public String getDisplayName() {
        return this.data.displayName;
    }

    public float getPrice() {
        return this.data.price;
    }

    public float getHirePrice() {
        return this.data.hirePrice;
    }

    public Vector2 getOrigin() {
        return new Vector2(this.data.origin);
    }

    public Vector2 getShipBuilderOrigin() {
        return new Vector2(this.data.shipBuilderOrigin);
    }

    public static final class Data {
        public String internalName;
        public float size;
        public int maxLife;
        public List<GunSlot> gunSlots = new ArrayList<GunSlot>();
        public List<DSParticleEmitter> particleEmitters = new ArrayList<DSParticleEmitter>();
        public List<Vector2> lightSrcPoss = new ArrayList<Vector2>();
        public float durability;
        public List<Vector2> forceBeaconPoss = new ArrayList<Vector2>();
        public List<Vector2> doorPoss = new ArrayList<Vector2>();
        public TextureAtlas.AtlasRegion icon;
        public Type type;
        public TextureAtlas.AtlasRegion tex;
        public Engine.Config engineConfig;
        public AbilityConfig ability;
        public float approxRadius;
        public String displayName;
        public float price;
        public float hirePrice;
        public Vector2 origin = new Vector2();
        public Vector2 shipBuilderOrigin = new Vector2();

        public Data() {
        }

        public Data(Data src) {
            this.internalName = src.internalName;
            this.size = src.size;
            this.maxLife = src.maxLife;
            this.lightSrcPoss = HullConfig.deepCopyOf(src.lightSrcPoss);
            this.durability = src.durability;
            this.forceBeaconPoss = HullConfig.deepCopyOf(src.forceBeaconPoss);
            this.doorPoss = HullConfig.deepCopyOf(src.doorPoss);
            this.icon = new TextureAtlas.AtlasRegion(src.icon);
            this.type = src.type;
            this.tex = new TextureAtlas.AtlasRegion(src.tex);
            this.engineConfig = src.engineConfig;
            this.ability = src.ability;
            this.approxRadius = src.approxRadius;
            this.displayName = src.displayName;
            this.price = src.price;
            this.hirePrice = src.hirePrice;
            this.origin = new Vector2(src.origin);
            this.shipBuilderOrigin = new Vector2(src.shipBuilderOrigin);
            this.gunSlots.addAll(src.gunSlots);
            this.particleEmitters.addAll(src.particleEmitters);
        }
    }

    public static enum Type {
        STD("std"),
        BIG("big"),
        STATION("station");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type forName(String name) {
            for (Type t : Type.values()) {
                if (!t.name.equals(name)) continue;
                return t;
            }
            return null;
        }
    }
}

