/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.sound;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.TimeUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.destinationsol.common.DebugCol;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;

public class DebugHint {
    private static final long MAX_AWAIT = 3000L;
    private final Vector2 position;
    private final Map<String, Long> myMsgs;
    private SolObject myOwner;
    private String myMsg;

    public DebugHint(SolObject owner, Vector2 position) {
        this.myOwner = owner;
        this.position = new Vector2(position);
        this.myMsgs = new HashMap<String, Long>();
    }

    public void add(String value) {
        boolean needsRebuild = !this.myMsgs.containsKey(value);
        this.myMsgs.put(value, TimeUtils.millis() + 3000L);
        if (needsRebuild) {
            this.rebuild();
        }
    }

    private void rebuild() {
        StringBuilder sb = new StringBuilder();
        for (String msg : this.myMsgs.keySet()) {
            sb.append(msg).append("\n");
        }
        this.myMsg = sb.toString();
    }

    public void update(SolGame game) {
        if (this.myOwner != null) {
            if (this.myOwner.shouldBeRemoved(game)) {
                this.myOwner = null;
            } else {
                this.position.set(this.myOwner.getPosition());
            }
        }
        long now = TimeUtils.millis();
        boolean needsRebuild = false;
        Iterator<Map.Entry<String, Long>> it = this.myMsgs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> e = it.next();
            if (e.getValue() > now) continue;
            it.remove();
            needsRebuild = true;
        }
        if (needsRebuild) {
            this.rebuild();
        }
    }

    public boolean shouldRemove() {
        return this.myMsgs.isEmpty();
    }

    public void draw(GameDrawer drawer, SolGame game) {
        float fontSz = game.getCam().getDebugFontSize();
        drawer.drawString(this.myMsg, this.position.x, this.position.y, fontSz, false, DebugCol.HINT);
    }
}

