/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.sound;

import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.destinationsol.common.Nullable;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.sound.DebugHint;

public class DebugHintDrawer {
    private final Map<SolObject, DebugHint> myTracedNotes = new HashMap<SolObject, DebugHint>();
    private final Map<Vector2, DebugHint> myFreeNotes = new HashMap<Vector2, DebugHint>();

    public void add(@Nullable SolObject owner, Vector2 position, String value) {
        DebugHint dh = owner == null ? this.myFreeNotes.computeIfAbsent(position, p -> new DebugHint(null, (Vector2)p)) : this.myTracedNotes.computeIfAbsent(owner, o -> new DebugHint((SolObject)o, o.getPosition()));
        dh.add(value);
    }

    public void update(SolGame game) {
        this.updateEach(game, this.myTracedNotes.values().iterator());
        this.updateEach(game, this.myFreeNotes.values().iterator());
    }

    private void updateEach(SolGame game, Iterator<DebugHint> it) {
        while (it.hasNext()) {
            DebugHint n = it.next();
            n.update(game);
            if (!n.shouldRemove()) continue;
            it.remove();
        }
    }

    public void draw(GameDrawer drawer, SolGame game) {
        for (DebugHint n : this.myTracedNotes.values()) {
            n.draw(drawer, game);
        }
        for (DebugHint n : this.myFreeNotes.values()) {
            n.draw(drawer, game);
        }
    }
}

