/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.sound;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;
import java.util.Map;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.sound.OggSound;
import org.destinationsol.assets.sound.PlayableSound;
import org.destinationsol.common.Nullable;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.sound.DebugHintDrawer;

public class OggSoundManager {
    private final Map<String, OggSound> soundMap = new HashMap<String, OggSound>();
    private final Map<SolObject, Map<OggSound, Float>> loopedSoundMap = new HashMap<SolObject, Map<OggSound, Float>>();
    private final DebugHintDrawer debugHintDrawer = new DebugHintDrawer();
    private float myLoopAwait;

    public OggSound getSound(String path) {
        return this.getSound(path, 1.0f);
    }

    public OggSound getSound(String path, float basePitch) {
        if (this.soundMap.containsKey(path)) {
            return this.soundMap.get(path);
        }
        OggSound sound = Assets.getSound(path);
        sound.setBasePitch(basePitch);
        this.soundMap.put(path, sound);
        return sound;
    }

    public void play(SolGame game, PlayableSound playableSound, @Nullable Vector2 position, @Nullable SolObject source, float volumeMultiplier) {
        float globalVolumeMultiplier;
        if (playableSound == null) {
            return;
        }
        OggSound sound = playableSound.getOggSound();
        if (source == null && position == null) {
            throw new AssertionError((Object)"Either position or source must be non-null");
        }
        if (source == null && sound.getLoopTime() > 0.0f) {
            throw new AssertionError((Object)("Attempted to loop a sound without a parent object: " + sound.getUrn()));
        }
        if (position == null) {
            position = source.getPosition();
        }
        if ((globalVolumeMultiplier = game.getSolApplication().getOptions().sfxVolume.getVolume()) == 0.0f) {
            return;
        }
        Vector2 cameraPosition = game.getCam().getPosition();
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet();
        float airPercentage = 0.0f;
        if (nearestPlanet.getConfig().skyConfig != null) {
            float distanceToAtmosphere = cameraPosition.dst(nearestPlanet.getPosition()) - nearestPlanet.getGroundHeight() - 7.0f;
            airPercentage = SolMath.clamp(1.0f - distanceToAtmosphere / 7.0f);
        }
        if (DebugOptions.SOUND_IN_SPACE) {
            airPercentage = 1.0f;
        }
        float maxSoundDist = 1.0f + 4.2f * airPercentage;
        Hero hero = game.getHero();
        float soundRadius = hero.isTranscendent() ? 0.0f : hero.getHull().config.getApproxRadius();
        float distance = position.dst(cameraPosition) - soundRadius;
        float distanceMultiplier = SolMath.clamp(1.0f - distance / maxSoundDist);
        float volume = sound.getBaseVolume() * volumeMultiplier * distanceMultiplier * globalVolumeMultiplier;
        if (volume <= 0.0f) {
            return;
        }
        float pitch = SolRandom.randomFloat(0.97f, 1.03f) * game.getTimeFactor() * playableSound.getBasePitch();
        if (this.skipLooped(source, sound, game.getTime())) {
            return;
        }
        if (DebugOptions.SOUND_INFO) {
            this.debugHintDrawer.add(source, position, sound.toString());
        }
        Sound gdxSound = sound.getSound();
        gdxSound.play(volume, pitch, 0.0f);
    }

    public void play(SolGame game, PlayableSound sound, @Nullable Vector2 position, @Nullable SolObject source) {
        this.play(game, sound, position, source, 1.0f);
    }

    private boolean skipLooped(SolObject source, OggSound sound, float time) {
        boolean playing;
        if (sound.getLoopTime() == 0.0f) {
            return false;
        }
        Map<OggSound, Float> looped = this.loopedSoundMap.get(source);
        if (looped == null) {
            looped = new HashMap<OggSound, Float>();
            this.loopedSoundMap.put(source, looped);
            playing = false;
        } else {
            Float endTime = looped.get(sound);
            if (endTime == null || endTime.floatValue() <= time) {
                looped.put(sound, Float.valueOf(time + sound.getLoopTime()));
                playing = false;
            } else {
                playing = time < endTime.floatValue();
            }
        }
        return playing;
    }

    public void drawDebug(GameDrawer drawer, SolGame game) {
        if (DebugOptions.SOUND_INFO) {
            this.debugHintDrawer.draw(drawer, game);
        }
    }

    public void update(SolGame game) {
        if (DebugOptions.SOUND_INFO) {
            this.debugHintDrawer.update(game);
        }
        this.myLoopAwait -= game.getTimeStep();
        if (this.myLoopAwait <= 0.0f) {
            this.myLoopAwait = 30.0f;
            this.cleanLooped(game);
        }
    }

    private void cleanLooped(SolGame game) {
        this.loopedSoundMap.keySet().removeIf(o -> o.shouldBeRemoved(game));
    }

    public void dispose() {
        for (OggSound sound : this.soundMap.values()) {
            sound.doDispose();
        }
    }
}

