/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.ArrayList;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class CreditsScreen
extends SolUiBaseScreen {
    private static final float MAX_AWAIT = 6.0f;
    private final TextureAtlas.AtlasRegion backgroundTexture;
    private final SolUiControl closeControl;
    private DisplayDimensions displayDimensions;
    private final ArrayList<String> myPages = new ArrayList();
    private final Color myColor;
    private int pageIndex;
    private float pageProgressPercent;

    CreditsScreen(GameOptions gameOptions) {
        String[][] sss;
        this.displayDimensions = SolApplication.displayDimensions;
        this.closeControl = new SolUiControl(MenuLayout.bottomRightFloatingButton(this.displayDimensions), true, gameOptions.getKeyEscape());
        this.closeControl.setDisplayName("Close");
        this.controls.add(this.closeControl);
        this.myColor = SolColor.col(1.0f, 1.0f);
        for (String[] ss : sss = new String[][]{{"A game from", "", "MovingBlocks"}, {"Original Creators", "", "Idea, coding, team lead:", "Milosh Petrov", "", "Drawing:", "Kent C. Jensen", "", "Additional coding:", "Nika \"NoiseDoll\" Burimenko", "", "Additional drawing:", "Julia Nikolaeva"}, {"Contributors on GitHub", "", "Cervator, Rulasmur", "theotherjay, LinusVanElswijk", "SimonC4, grauerkoala, rzats", "LadySerenaKitty, askneller", "JGelfand, AvaLanCS, scirelli", "Sigma-One, vampcat, malanius", "AonoZan, ererbe, SurajDutta", "jasyohuang, Steampunkery", "Graviton48, Adrijaned, MaxBorsch", "sohil123, FieryPheonix909", "digitalripperynr, NicholasBatesNZ", "Pendi, Torpedo99, AndyTechGuy", "BenjaminAmos, dannykelemen", "msteiger, oniatus, arpitkamboj", "manas96, IsaacLic, Mpcs, ZPendi", "nailorcngci, FearlessTobi, ujjman", "ThisIsPIRI"}, {"Soundtrack by NeonInsect"}, {"Game engine:", "LibGDX", "", "Windows wrapper:", "Launch4J"}, {"Font:", "\"Jet Set\" by Captain Falcon", "", "Sounds by FreeSound.org users:", "Smokum, Mattpavone", "Hanstimm, Sonidor,", "Isaac200000, TheHadnot, Garzul", "Dpoggioli, Raremess, Giddykipper,", "Steveygos93"}}) {
            StringBuilder page = new StringBuilder();
            for (String s : ss) {
                page.append(s).append("\n");
            }
            this.myPages.add(page.toString());
        }
        this.backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        this.pageIndex = 0;
        this.pageProgressPercent = 0.0f;
        this.myColor.a = 0.0f;
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        float a;
        if (this.closeControl.isJustOff()) {
            solApplication.getInputManager().setScreen(solApplication, solApplication.getMenuScreens().main);
            return;
        }
        this.pageProgressPercent += 0.0027777778f;
        if (this.pageProgressPercent > 1.0f) {
            this.pageProgressPercent = 0.0f;
            ++this.pageIndex;
            if (this.pageIndex >= this.myPages.size()) {
                this.pageIndex = 0;
            }
        }
        if ((a = this.pageProgressPercent * 2.0f) > 1.0f) {
            a = 2.0f - a;
        }
        this.myColor.a = SolMath.clamp(a *= 3.0f);
        solApplication.getMenuBackgroundManager().update();
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
        solApplication.getMenuBackgroundManager().draw(uiDrawer);
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.drawString(this.myPages.get(this.pageIndex), this.displayDimensions.getRatio() / 2.0f, 0.5f, 1.0f, true, this.myColor);
    }
}

