/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.menu.InputConfigItem;
import org.destinationsol.menu.InputMapOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputMapControllerScreen
extends InputMapOperations {
    private static final String HEADER_TEXT = "Controller Inputs";
    private static Logger logger = LoggerFactory.getLogger(InputMapControllerScreen.class);
    private boolean isEnterNewKey;
    private List<InputConfigItem> itemsList = new ArrayList<InputConfigItem>();
    private int selectedIndex;
    private int controllerItems;

    private InputConfigItem InitItem(int axis, int button, String displayName) {
        int controllerInput;
        boolean isAxis = axis > -1;
        int n = controllerInput = isAxis ? axis : button;
        String inputName = controllerInput == -1 ? "" : (isAxis ? "Axis: " : "Button: ") + controllerInput;
        return new InputConfigItem(displayName, inputName, isAxis, controllerInput);
    }

    private void InitialiseList(GameOptions gameOptions) {
        this.itemsList.clear();
        this.itemsList.add(this.InitItem(gameOptions.getControllerAxisUpDown(), gameOptions.getControllerButtonUp(), "Up"));
        this.itemsList.add(this.InitItem(gameOptions.getControllerAxisUpDown(), gameOptions.getControllerButtonDown(), "Down"));
        this.itemsList.add(this.InitItem(gameOptions.getControllerAxisLeftRight(), gameOptions.getControllerButtonLeft(), "Left"));
        this.itemsList.add(this.InitItem(gameOptions.getControllerAxisLeftRight(), gameOptions.getControllerButtonRight(), "Right"));
        this.itemsList.add(this.InitItem(gameOptions.getControllerAxisShoot(), gameOptions.getControllerButtonShoot(), "Shoot"));
        this.itemsList.add(this.InitItem(gameOptions.getControllerAxisShoot2(), gameOptions.getControllerButtonShoot2(), "Shoot Secondary"));
        this.itemsList.add(this.InitItem(gameOptions.getControllerAxisAbility(), gameOptions.getControllerButtonAbility(), "Ability"));
        this.controllerItems = this.itemsList.size();
        this.itemsList.add(new InputConfigItem("Pause", gameOptions.getKeyPauseName()));
        this.itemsList.add(new InputConfigItem("Map", gameOptions.getKeyMapName()));
        this.itemsList.add(new InputConfigItem("Inventory", gameOptions.getKeyInventoryName()));
        this.itemsList.add(new InputConfigItem("Drop Item", gameOptions.getKeyDropName()));
        this.itemsList.add(new InputConfigItem("Talk", gameOptions.getKeyTalkName()));
        this.itemsList.add(new InputConfigItem("Sell", gameOptions.getKeySellMenuName()));
        this.itemsList.add(new InputConfigItem("Buy", gameOptions.getKeyBuyMenuName()));
        this.itemsList.add(new InputConfigItem("Change Ship", gameOptions.getKeyChangeShipMenuName()));
        this.itemsList.add(new InputConfigItem("Hire Ship", gameOptions.getKeyHireShipMenuName()));
    }

    @Override
    public void save(GameOptions gameOptions) {
        InputConfigItem item;
        int index = 0;
        gameOptions.setControllerAxisUpDown((item = this.itemsList.get(index++)).isAxis() ? item.getControllerInput() : -1);
        gameOptions.setControllerButtonUp(!item.isAxis() ? item.getControllerInput() : -1);
        item = this.itemsList.get(index++);
        gameOptions.setControllerAxisUpDown(item.isAxis() ? item.getControllerInput() : -1);
        gameOptions.setControllerButtonDown(!item.isAxis() ? item.getControllerInput() : -1);
        item = this.itemsList.get(index++);
        gameOptions.setControllerAxisLeftRight(item.isAxis() ? item.getControllerInput() : -1);
        gameOptions.setControllerButtonLeft(!item.isAxis() ? item.getControllerInput() : -1);
        item = this.itemsList.get(index++);
        gameOptions.setControllerAxisLeftRight(item.isAxis() ? item.getControllerInput() : -1);
        gameOptions.setControllerButtonRight(!item.isAxis() ? item.getControllerInput() : -1);
        item = this.itemsList.get(index++);
        gameOptions.setControllerAxisShoot(item.isAxis() ? item.getControllerInput() : -1);
        gameOptions.setControllerButtonShoot(!item.isAxis() ? item.getControllerInput() : -1);
        item = this.itemsList.get(index++);
        gameOptions.setControllerAxisShoot2(item.isAxis() ? item.getControllerInput() : -1);
        gameOptions.setControllerButtonShoot2(!item.isAxis() ? item.getControllerInput() : -1);
        item = this.itemsList.get(index++);
        gameOptions.setControllerAxisAbility(item.isAxis() ? item.getControllerInput() : -1);
        gameOptions.setControllerButtonAbility(!item.isAxis() ? item.getControllerInput() : -1);
        gameOptions.setKeyPauseName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyMapName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyInventoryName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyDropName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyTalkName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeySellMenuName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyBuyMenuName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyChangeShipMenuName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyHireShipMenuName(this.itemsList.get(index++).getInputKey());
        gameOptions.save();
    }

    @Override
    public void resetToDefaults(GameOptions gameOptions) {
        int index = 0;
        this.itemsList.set(index++, this.InitItem(5, -1, "Up"));
        this.itemsList.set(index++, this.InitItem(5, -1, "Down"));
        this.itemsList.set(index++, this.InitItem(2, -1, "Left"));
        this.itemsList.set(index++, this.InitItem(2, -1, "Right"));
        this.itemsList.set(index++, this.InitItem(1, -1, "Shoot"));
        this.itemsList.set(index++, this.InitItem(0, -1, "Shoot Secondary"));
        this.itemsList.set(index++, this.InitItem(-1, 14, "Ability"));
        InputConfigItem item = this.itemsList.get(index);
        item.setInputKey("P");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("Tab");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("I");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("D");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("T");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("S");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("B");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("C");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("H");
        this.itemsList.set(index++, item);
    }

    private void removeDuplicateButtons(int buttonIndex) {
        for (InputConfigItem item : this.itemsList) {
            if (item.isAxis() || item.getControllerInput() != buttonIndex) continue;
            item.setControllerInput(-1);
            item.setInputKey("");
        }
    }

    private void removeDuplicateKeys(int keyCode) {
        for (InputConfigItem item : this.itemsList) {
            if (Input.Keys.valueOf((String)item.getInputKey()) != keyCode) continue;
            item.setInputKey("");
        }
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        this.InitialiseList(solApplication.getOptions());
        Controllers.clearListeners();
        this.isEnterNewKey = false;
        this.selectedIndex = 0;
    }

    @Override
    public String getHeader() {
        return HEADER_TEXT;
    }

    @Override
    public String getDisplayDetail() {
        if (this.isEnterNewKey) {
            if (this.selectedIndex >= this.controllerItems) {
                return "Enter New Key";
            }
            return "Enter New Controller Input";
        }
        return "Only ship controls can use a\ncontroller in this version.\n\nMenu controls need to use\nthe keyboard.";
    }

    @Override
    public boolean isEnterNewKey() {
        return this.isEnterNewKey;
    }

    @Override
    public void setEnterNewKey(boolean newKey) {
        this.isEnterNewKey = newKey;
        if (!this.isEnterNewKey) {
            Gdx.input.setInputProcessor(null);
            Controllers.clearListeners();
        } else {
            Gdx.input.setInputProcessor((InputProcessor)new InputAdapter(){

                public boolean keyUp(int keycode) {
                    if (keycode == 131) {
                        return true;
                    }
                    if (InputMapControllerScreen.this.selectedIndex >= InputMapControllerScreen.this.controllerItems) {
                        InputMapControllerScreen.this.removeDuplicateKeys(keycode);
                        InputConfigItem item = (InputConfigItem)InputMapControllerScreen.this.itemsList.get(InputMapControllerScreen.this.selectedIndex);
                        item.setInputKey(Input.Keys.toString((int)keycode));
                        InputMapControllerScreen.this.itemsList.set(InputMapControllerScreen.this.selectedIndex, item);
                    }
                    Gdx.input.setInputProcessor(null);
                    Controllers.clearListeners();
                    InputMapControllerScreen.this.isEnterNewKey = false;
                    return true;
                }
            });
            Controllers.addListener((ControllerListener)new ControllerListener(){

                public int indexOf(Controller controller) {
                    return Controllers.getControllers().indexOf((Object)controller, true);
                }

                public void connected(Controller controller) {
                }

                public void disconnected(Controller controller) {
                }

                public boolean buttonDown(Controller controller, int buttonIndex) {
                    return true;
                }

                public boolean buttonUp(Controller controller, int buttonIndex) {
                    logger.debug("#{}, button  {} up", (Object)this.indexOf(controller), (Object)buttonIndex);
                    if (InputMapControllerScreen.this.selectedIndex < InputMapControllerScreen.this.controllerItems) {
                        InputMapControllerScreen.this.removeDuplicateButtons(buttonIndex);
                        InputConfigItem item = (InputConfigItem)InputMapControllerScreen.this.itemsList.get(InputMapControllerScreen.this.selectedIndex);
                        item.setIsAxis(false);
                        item.setControllerInput(buttonIndex);
                        item.setInputKey("Button: " + buttonIndex);
                        InputMapControllerScreen.this.itemsList.set(InputMapControllerScreen.this.selectedIndex, item);
                    }
                    Gdx.input.setInputProcessor(null);
                    Controllers.clearListeners();
                    InputMapControllerScreen.this.isEnterNewKey = false;
                    return true;
                }

                public boolean axisMoved(Controller controller, int axisIndex, float value) {
                    logger.debug("#{}, axis {}: {}", new Object[]{this.indexOf(controller), axisIndex, Float.valueOf(value)});
                    if (value > 0.5f || value < -0.5f) {
                        if (InputMapControllerScreen.this.selectedIndex < InputMapControllerScreen.this.controllerItems) {
                            InputConfigItem item = (InputConfigItem)InputMapControllerScreen.this.itemsList.get(InputMapControllerScreen.this.selectedIndex);
                            item.setIsAxis(true);
                            item.setControllerInput(axisIndex);
                            item.setInputKey("Axis: " + axisIndex);
                            InputMapControllerScreen.this.itemsList.set(InputMapControllerScreen.this.selectedIndex, item);
                        }
                        Gdx.input.setInputProcessor(null);
                        Controllers.clearListeners();
                        InputMapControllerScreen.this.isEnterNewKey = false;
                    }
                    return true;
                }

                public boolean povMoved(Controller controller, int povIndex, PovDirection value) {
                    return false;
                }

                public boolean xSliderMoved(Controller controller, int sliderIndex, boolean value) {
                    return false;
                }

                public boolean ySliderMoved(Controller controller, int sliderIndex, boolean value) {
                    return false;
                }

                public boolean accelerometerMoved(Controller controller, int accelerometerIndex, Vector3 value) {
                    return false;
                }
            });
        }
    }

    @Override
    public List<InputConfigItem> getItems(GameOptions gameOptions) {
        return this.itemsList;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }
}

