/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.menu.InputConfigItem;
import org.destinationsol.menu.InputMapOperations;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class InputMapMixedScreen
extends InputMapOperations {
    private static final String HEADER_TEXT = "Keyboard and Mouse Inputs";
    private List<InputConfigItem> itemsList = new ArrayList<InputConfigItem>();
    private boolean isEnterNewKey;
    private int selectedIndex;

    private void InitialiseList(GameOptions gameOptions) {
        this.itemsList.clear();
        InputConfigItem mouseUp = new InputConfigItem("Up", gameOptions.getKeyUpMouseName());
        this.itemsList.add(mouseUp);
        InputConfigItem mouseDown = new InputConfigItem("Down", gameOptions.getKeyDownMouseName());
        this.itemsList.add(mouseDown);
        InputConfigItem pause = new InputConfigItem("Pause", gameOptions.getKeyPauseName());
        this.itemsList.add(pause);
        InputConfigItem map = new InputConfigItem("Map", gameOptions.getKeyMapName());
        this.itemsList.add(map);
        InputConfigItem inventory = new InputConfigItem("Inventory", gameOptions.getKeyInventoryName());
        this.itemsList.add(inventory);
        InputConfigItem drop = new InputConfigItem("Drop Item", gameOptions.getKeyDropName());
        this.itemsList.add(drop);
        InputConfigItem talk = new InputConfigItem("Talk", gameOptions.getKeyTalkName());
        this.itemsList.add(talk);
        InputConfigItem sell = new InputConfigItem("Sell", gameOptions.getKeySellMenuName());
        this.itemsList.add(sell);
        InputConfigItem buy = new InputConfigItem("Buy", gameOptions.getKeyBuyMenuName());
        this.itemsList.add(buy);
        InputConfigItem changeShip = new InputConfigItem("Change Ship", gameOptions.getKeyChangeShipMenuName());
        this.itemsList.add(changeShip);
        InputConfigItem hireShip = new InputConfigItem("Hire Ship", gameOptions.getKeyHireShipMenuName());
        this.itemsList.add(hireShip);
    }

    @Override
    public void save(GameOptions gameOptions) {
        int index = 0;
        gameOptions.setKeyUpMouseName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyDownMouseName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyPauseName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyMapName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyInventoryName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyDropName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyTalkName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeySellMenuName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyBuyMenuName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyChangeShipMenuName(this.itemsList.get(index++).getInputKey());
        gameOptions.setKeyHireShipMenuName(this.itemsList.get(index).getInputKey());
        gameOptions.save();
    }

    @Override
    public void resetToDefaults(GameOptions gameOptions) {
        int index = 0;
        InputConfigItem item = this.itemsList.get(index);
        item.setInputKey("W");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("S");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("P");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("Tab");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("I");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("D");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("T");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("S");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("B");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("C");
        this.itemsList.set(index++, item);
        item = this.itemsList.get(index);
        item.setInputKey("H");
        this.itemsList.set(index, item);
    }

    @Override
    public List<SolUiControl> getControls() {
        return this.controls;
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
    }

    private void removeDuplicateKeys(int keyCode) {
        for (InputConfigItem item : this.itemsList) {
            if (Input.Keys.valueOf((String)item.getInputKey()) != keyCode) continue;
            item.setInputKey("");
        }
    }

    @Override
    public void onAdd(SolApplication cmp) {
        this.InitialiseList(cmp.getOptions());
        this.isEnterNewKey = false;
        this.selectedIndex = 0;
    }

    @Override
    public String getHeader() {
        return HEADER_TEXT;
    }

    @Override
    public String getDisplayDetail() {
        if (this.isEnterNewKey) {
            return "Enter New Key";
        }
        return "";
    }

    @Override
    public boolean isEnterNewKey() {
        return this.isEnterNewKey;
    }

    @Override
    public void setEnterNewKey(boolean newKey) {
        this.isEnterNewKey = newKey;
        if (!this.isEnterNewKey) {
            Gdx.input.setInputProcessor(null);
        } else {
            Gdx.input.setInputProcessor((InputProcessor)new InputAdapter(){

                public boolean keyUp(int keycode) {
                    if (keycode == 131) {
                        return true;
                    }
                    InputMapMixedScreen.this.removeDuplicateKeys(keycode);
                    InputConfigItem item = (InputConfigItem)InputMapMixedScreen.this.itemsList.get(InputMapMixedScreen.this.selectedIndex);
                    item.setInputKey(Input.Keys.toString((int)keycode));
                    InputMapMixedScreen.this.itemsList.set(InputMapMixedScreen.this.selectedIndex, item);
                    Gdx.input.setInputProcessor(null);
                    InputMapMixedScreen.this.isEnterNewKey = false;
                    return true;
                }
            });
        }
    }

    @Override
    public List<InputConfigItem> getItems(GameOptions gameOptions) {
        return this.itemsList;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }
}

