/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.menu.InputConfigItem;
import org.destinationsol.menu.InputMapControllerScreen;
import org.destinationsol.menu.InputMapKeyboardScreen;
import org.destinationsol.menu.InputMapMixedScreen;
import org.destinationsol.menu.InputMapOperations;
import org.destinationsol.menu.MenuScreens;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class InputMapScreen
extends SolUiBaseScreen {
    private static final float IMG_COL_PERC = 0.1f;
    private static final float EQUI_COL_PERC = 0.1f;
    private static final float PRICE_COL_PERC = 0.1f;
    private static final float AMT_COL_PERC = 0.1f;
    private static final float SMALL_GAP = 0.004f;
    private static final float HEADER_TEXT_OFFSET = 0.005f;
    private static final int BUTTON_ROWS = 4;
    final InputMapKeyboardScreen inputMapKeyboardScreen;
    final InputMapControllerScreen inputMapControllerScreen;
    final InputMapMixedScreen inputMapMixedScreen;
    private final TextureAtlas.AtlasRegion backgroundTexture;
    private final SolUiControl[] itemControls;
    private final SolUiControl previousControl;
    private final SolUiControl nextControl;
    private final SolUiControl cancelControl;
    private final SolUiControl saveControl;
    private final SolUiControl defaultsControl;
    private final SolUiControl upControl;
    private final SolUiControl downControl;
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;
    private final Vector2 listHeaderPos;
    private final Rectangle listArea;
    private final Rectangle detailsArea;
    private final Rectangle itemControlsArea;
    private InputMapOperations operations;
    private int page;
    private int selectedIndex;

    InputMapScreen(GameOptions gameOptions) {
        float contentW = 0.8f;
        float col0 = this.displayDimensions.getRatio() / 2.0f - contentW / 2.0f;
        float row = 0.2f;
        float bigGap = 0.024f;
        float headerH = 0.03f;
        this.listHeaderPos = new Vector2(col0 + 0.005f, row + 0.005f);
        float listCtrlW = contentW * 0.15f;
        Rectangle nextArea = new Rectangle(col0 + contentW - listCtrlW, row, listCtrlW, headerH);
        this.nextControl = new SolUiControl(nextArea, true, gameOptions.getKeyRight());
        this.nextControl.setDisplayName(">");
        this.controls.add(this.nextControl);
        Rectangle prevArea = new Rectangle(nextArea.x - 0.004f - listCtrlW, row, listCtrlW, headerH);
        this.previousControl = new SolUiControl(prevArea, true, gameOptions.getKeyLeft());
        this.previousControl.setDisplayName("<");
        this.controls.add(this.previousControl);
        float itemRowH = 0.04f;
        float listRow0 = row += headerH + 0.004f;
        this.itemControls = new SolUiControl[8];
        for (int i = 0; i < 8; ++i) {
            SolUiControl itemCtrl;
            Rectangle itemR = new Rectangle(col0, row, contentW, itemRowH);
            this.itemControls[i] = itemCtrl = new SolUiControl(itemR, true, new int[0]);
            this.controls.add(itemCtrl);
            row += itemRowH + 0.004f;
        }
        this.listArea = new Rectangle(col0, row, contentW, row - 0.004f - listRow0);
        row += bigGap;
        float itemCtrlAreaW = contentW * 0.4f;
        this.itemControlsArea = new Rectangle(col0 + contentW - itemCtrlAreaW, row += headerH + 0.004f, itemCtrlAreaW, 0.2f);
        this.detailsArea = new Rectangle(col0, row, contentW - itemCtrlAreaW - 0.004f, this.itemControlsArea.height);
        this.cancelControl = new SolUiControl(this.itemControlRectangle(3), true, gameOptions.getKeyClose());
        this.cancelControl.setDisplayName("Cancel");
        this.controls.add(this.cancelControl);
        this.saveControl = new SolUiControl(this.itemControlRectangle(2), true, new int[0]);
        this.saveControl.setDisplayName("Save");
        this.controls.add(this.saveControl);
        this.defaultsControl = new SolUiControl(this.itemControlRectangle(1), true, new int[0]);
        this.defaultsControl.setDisplayName("Defaults");
        this.controls.add(this.defaultsControl);
        this.upControl = new SolUiControl(null, true, gameOptions.getKeyUp());
        this.controls.add(this.upControl);
        this.downControl = new SolUiControl(null, true, gameOptions.getKeyDown());
        this.controls.add(this.downControl);
        this.inputMapKeyboardScreen = new InputMapKeyboardScreen();
        this.inputMapControllerScreen = new InputMapControllerScreen();
        this.inputMapMixedScreen = new InputMapMixedScreen();
        this.backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
    }

    @Override
    public void updateCustom(SolApplication cmp, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        GameOptions gameOptions = cmp.getOptions();
        SolInputManager im = cmp.getInputManager();
        MenuScreens screens = cmp.getMenuScreens();
        if (this.saveControl.isJustOff()) {
            this.operations.save(gameOptions);
            im.setScreen(cmp, screens.options);
        }
        if (this.cancelControl.isJustOff()) {
            if (this.operations.isEnterNewKey()) {
                this.operations.setEnterNewKey(false);
            } else {
                im.setScreen(cmp, screens.options);
            }
        }
        if (this.operations.isEnterNewKey()) {
            this.previousControl.setEnabled(false);
            this.nextControl.setEnabled(false);
            this.upControl.setEnabled(false);
            this.downControl.setEnabled(false);
            for (SolUiControl itemControl : this.itemControls) {
                itemControl.setEnabled(false);
            }
            return;
        }
        this.upControl.setEnabled(true);
        this.downControl.setEnabled(true);
        for (SolUiControl itemControl : this.itemControls) {
            itemControl.setEnabled(true);
        }
        if (this.defaultsControl.isJustOff()) {
            this.operations.resetToDefaults(gameOptions);
        }
        List<InputConfigItem> itemsList = this.operations.getItems(gameOptions);
        int groupCount = itemsList.size();
        int pageCount = groupCount / 8;
        int offset = this.page * 8;
        for (int i = 0; i < this.itemControls.length; ++i) {
            SolUiControl itemCtrl = this.itemControls[i];
            if (!itemCtrl.isJustOff()) continue;
            this.selectedIndex = i + offset;
            this.operations.setEnterNewKey(true);
        }
        if (this.previousControl.isJustOff()) {
            --this.page;
        }
        if (this.nextControl.isJustOff()) {
            ++this.page;
        }
        if (pageCount == 0 || pageCount * 8 < groupCount) {
            ++pageCount;
        }
        if (this.page < 0) {
            this.page = 0;
        }
        if (this.page >= pageCount) {
            this.page = pageCount - 1;
        }
        this.previousControl.setEnabled(0 < this.page);
        this.nextControl.setEnabled(this.page < pageCount - 1);
        if (this.selectedIndex < offset || this.selectedIndex >= offset + 8) {
            this.selectedIndex = offset;
        }
        if (this.upControl.isJustOff()) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = 0;
            }
            if (this.selectedIndex < offset) {
                --this.page;
            }
        }
        if (this.downControl.isJustOff()) {
            ++this.selectedIndex;
            if (this.selectedIndex >= groupCount) {
                this.selectedIndex = groupCount - 1;
            }
            if (this.selectedIndex >= offset + 8) {
                ++this.page;
            }
            if (this.page >= pageCount) {
                this.page = pageCount - 1;
            }
        }
        this.operations.setSelectedIndex(this.selectedIndex);
        cmp.getMenuBackgroundManager().update();
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
        solApplication.getMenuBackgroundManager().draw(uiDrawer);
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        GameOptions gameOptions = solApplication.getOptions();
        List<InputConfigItem> list = this.operations.getItems(gameOptions);
        float imgColW = this.listArea.width * 0.1f;
        float equiColW = this.listArea.width * 0.1f;
        float priceWidth = this.listArea.width * 0.1f;
        float amtWidth = this.listArea.width * 0.1f;
        float nameWidth = this.listArea.width - imgColW - equiColW - priceWidth - amtWidth;
        for (int i = 0; i < this.itemControls.length; ++i) {
            int groupIdx = this.page * 8 + i;
            int groupCount = list.size();
            if (groupCount <= groupIdx) continue;
            SolUiControl itemCtrl = this.itemControls[i];
            String displayName = list.get(groupIdx).getDisplayName();
            String inputKey = list.get(groupIdx).getInputKey();
            Rectangle rect = itemCtrl.getScreenArea();
            float rowCenterY = rect.y + rect.height / 2.0f;
            uiDrawer.drawString(displayName, rect.x + equiColW + imgColW + nameWidth / 2.0f, rowCenterY, 0.7f, true, this.selectedIndex == groupIdx ? SolColor.WHITE : SolColor.G);
            uiDrawer.drawString(inputKey, rect.x + rect.width - amtWidth - priceWidth / 2.0f, rowCenterY, 0.7f, true, SolColor.LG);
        }
        uiDrawer.drawString(this.operations.getHeader(), this.listHeaderPos.x, this.listHeaderPos.y, 0.7f, false, SolColor.WHITE);
        uiDrawer.drawString(this.operations.getDisplayDetail(), this.detailsArea.x + 0.015f, this.detailsArea.y + 0.015f, 0.7f, false, SolColor.WHITE);
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        if (this.operations != null) {
            solApplication.getInputManager().addScreen(solApplication, this.operations);
        }
        this.page = 0;
        this.selectedIndex = 0;
    }

    private Rectangle itemControlRectangle(int row) {
        float h = (this.itemControlsArea.height - 0.012f) / 4.0f;
        return new Rectangle(this.itemControlsArea.x, this.itemControlsArea.y + (h + 0.004f) * (float)row, this.itemControlsArea.width, h);
    }

    void setOperations(InputMapOperations operations) {
        this.operations = operations;
    }
}

