/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.UiDrawer;

public class LoadingScreen
extends SolUiBaseScreen {
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;
    private final TextureAtlas.AtlasRegion backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
    private boolean loadTutorial;
    private boolean isNewGame;
    private String shipName;

    LoadingScreen() {
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        solApplication.play(this.loadTutorial, this.shipName, this.isNewGame);
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.drawString("Loading...", this.displayDimensions.getRatio() / 2.0f, 0.5f, 1.0f, true, SolColor.WHITE);
    }

    public void setMode(boolean loadTutorial, String shipName, boolean isNewGame) {
        this.loadTutorial = loadTutorial;
        this.shipName = shipName;
        this.isNewGame = isNewGame;
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
    }
}

