/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.music.OggMusicManager;
import org.destinationsol.common.SolColor;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.menu.MenuScreens;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class MainMenuScreen
extends SolUiBaseScreen {
    private final boolean isMobile;
    private final GameOptions gameOptions;
    private final TextureAtlas.AtlasRegion logoTexture;
    private final TextureAtlas.AtlasRegion backgroundTexture;
    private DisplayDimensions displayDimensions;
    private final SolUiControl tutorialControl;
    private final SolUiControl optionsControl;
    private final SolUiControl exitControl;
    private final SolUiControl newGameControl;
    private final SolUiControl creditsControl;
    private final int buttonWidth = 300;
    private final int buttonHeight = 75;
    private final int buttonPadding = 10;

    MainMenuScreen(boolean isMobile, GameOptions gameOptions) {
        this.isMobile = isMobile;
        this.gameOptions = gameOptions;
        this.displayDimensions = SolApplication.displayDimensions;
        this.tutorialControl = new SolUiControl(300, 75, UiDrawer.positions.get("bottom"), 0, this.calculateButtonOffsetFromBottom(3), true, 48);
        this.tutorialControl.setDisplayName("Tutorial");
        this.controls.add(this.tutorialControl);
        this.newGameControl = new SolUiControl(300, 75, UiDrawer.positions.get("bottom"), 0, this.calculateButtonOffsetFromBottom(2), true, gameOptions.getKeyShoot());
        this.newGameControl.setDisplayName("Play Game");
        this.controls.add(this.newGameControl);
        this.optionsControl = new SolUiControl(300, 75, UiDrawer.positions.get("bottom"), 0, this.calculateButtonOffsetFromBottom(1), true, 43);
        this.optionsControl.setDisplayName("Options");
        this.controls.add(this.optionsControl);
        this.exitControl = new SolUiControl(300, 75, UiDrawer.positions.get("bottom"), 0, this.calculateButtonOffsetFromBottom(0), true, gameOptions.getKeyEscape());
        this.exitControl.setDisplayName("Exit");
        this.controls.add(this.exitControl);
        this.creditsControl = new SolUiControl(MenuLayout.bottomRightFloatingButton(this.displayDimensions), true, 31);
        this.creditsControl.setDisplayName("Credits");
        this.controls.add(this.creditsControl);
        this.backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
        this.logoTexture = Assets.getAtlasRegion("engine:mainMenuLogo", Texture.TextureFilter.Linear);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        this.tutorialControl.setEnabled(solApplication.getOptions().controlType != GameOptions.ControlType.CONTROLLER);
        if (this.tutorialControl.isJustOff()) {
            solApplication.play(true, "Imperial Small", true);
            return;
        }
        SolInputManager inputManager = solApplication.getInputManager();
        MenuScreens screens = solApplication.getMenuScreens();
        if (this.newGameControl.isJustOff()) {
            inputManager.setScreen(solApplication, screens.newGame);
            return;
        }
        if (this.optionsControl.isJustOff()) {
            inputManager.setScreen(solApplication, screens.options);
            return;
        }
        if (this.exitControl.isJustOff()) {
            if (!this.isMobile) {
                solApplication.getOptions().save();
            }
            Gdx.app.exit();
            return;
        }
        if (this.creditsControl.isJustOff()) {
            inputManager.setScreen(solApplication, screens.credits);
        }
        solApplication.getMenuBackgroundManager().update();
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        OggMusicManager musicManager = solApplication.getMusicManager();
        if (!musicManager.getCurrentMusicSet().equals("menu")) {
            musicManager.playMusic("menu", this.gameOptions);
        }
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
        solApplication.getMenuBackgroundManager().draw(uiDrawer);
    }

    @Override
    public void drawImages(UiDrawer uiDrawer, SolApplication solApplication) {
        float sy = 0.35f;
        float sx = 0.64220184f;
        uiDrawer.draw((TextureRegion)this.logoTexture, 0.64220184f, 0.35f, 0.32110092f, 0.175f, this.displayDimensions.getRatio() / 2.0f, 0.275f, 0.0f, SolColor.WHITE);
    }

    private int calculateButtonOffsetFromBottom(int buttonIndex) {
        return -47 - buttonIndex * 85;
    }
}

