/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.math.Rectangle;
import org.destinationsol.SolApplication;
import org.destinationsol.ui.DisplayDimensions;

public class MenuLayout {
    public static final float BG_BORDER = 0.03f;
    private static final int numberOfRowsTotal = 5;
    private final float btnW;
    private final float btnH;
    private final float colCenter;
    private final float row0;
    private final float rowH;
    private final float myPad;

    public MenuLayout() {
        DisplayDimensions displayDimensions = SolApplication.displayDimensions;
        this.btnW = 0.4f * displayDimensions.getRatio();
        this.btnH = 0.1f;
        this.myPad = 0.1f * this.btnH;
        this.rowH = this.btnH + this.myPad;
        this.colCenter = 0.5f * displayDimensions.getRatio() - this.btnW / 2.0f;
        this.row0 = 1.0f - this.myPad - 5.0f * this.rowH;
    }

    static Rectangle bottomRightFloatingButton(DisplayDimensions aspectRatio) {
        float BUTTON_WIDTH = 0.15f;
        float BUTTON_HEIGHT = 0.07f;
        return new Rectangle(aspectRatio.getRatio() - 0.15f, 0.93f, 0.15f, 0.07f);
    }

    public Rectangle buttonRect(int col, int row) {
        float x = col == -1 ? this.colCenter : 0.5f;
        float y = this.row0 + this.rowH * (float)row;
        return new Rectangle(x, y, this.btnW, this.btnH);
    }

    public Rectangle background(int colCount, int startRow, int rowCount) {
        float x = colCount == -1 ? this.colCenter : 0.5f;
        float y = this.row0 + this.rowH * (float)startRow;
        return new Rectangle(x - 0.03f, y - 0.03f, this.btnW + 0.06f, this.rowH * (float)rowCount - this.myPad + 0.06f);
    }
}

