/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.SaveManager;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.menu.MenuScreens;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class NewGameScreen
extends SolUiBaseScreen {
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;
    private final TextureAtlas.AtlasRegion backgroundTexture;
    private final SolUiControl backControl;
    private final SolUiControl continueControl;
    private final SolUiControl newControl;

    NewGameScreen(MenuLayout menuLayout, GameOptions gameOptions) {
        this.continueControl = new SolUiControl(menuLayout.buttonRect(-1, 1), true, gameOptions.getKeyShoot());
        this.continueControl.setDisplayName("Continue");
        this.controls.add(this.continueControl);
        this.newControl = new SolUiControl(menuLayout.buttonRect(-1, 2), true, new int[0]);
        this.newControl.setDisplayName("New game");
        this.controls.add(this.newControl);
        this.backControl = new SolUiControl(menuLayout.buttonRect(-1, 4), true, gameOptions.getKeyEscape());
        this.backControl.setDisplayName("Cancel");
        this.controls.add(this.backControl);
        this.backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        this.continueControl.setEnabled(SaveManager.hasPreviousCompatibleShip());
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        MenuScreens screens = solApplication.getMenuScreens();
        SolInputManager im = solApplication.getInputManager();
        if (this.backControl.isJustOff()) {
            im.setScreen(solApplication, screens.main);
            return;
        }
        if (this.continueControl.isJustOff()) {
            solApplication.loadGame(false, null, false);
            return;
        }
        if (this.newControl.isJustOff()) {
            im.setScreen(solApplication, screens.newShip);
        }
        solApplication.getMenuBackgroundManager().update();
    }

    @Override
    public boolean isCursorOnBackground(SolInputManager.InputPointer inputPointer) {
        return true;
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
        solApplication.getMenuBackgroundManager().draw(uiDrawer);
    }
}

