/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolColor;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;

public class NewShipScreen
extends SolUiBaseScreen {
    private DisplayDimensions displayDimensions;
    private final TextureAtlas.AtlasRegion backgroundTexture;
    private SolUiControl okControl;
    private SolUiControl cancelControl;
    private SolUiControl systemCountControl;
    private SolUiControl playerSpawnConfigControl;
    private int playerSpawnConfigIndex = 0;
    private List<String> playerSpawnConfigNames = new ArrayList<String>();
    private int numberOfSystems = 2;

    NewShipScreen(MenuLayout menuLayout, GameOptions gameOptions) {
        this.displayDimensions = SolApplication.displayDimensions;
        this.loadPlayerSpawnConfigs();
        int row = 1;
        this.systemCountControl = new SolUiControl(menuLayout.buttonRect(-1, row++), true, new int[0]);
        this.systemCountControl.setDisplayName("Systems: " + this.numberOfSystems);
        this.controls.add(this.systemCountControl);
        this.playerSpawnConfigControl = new SolUiControl(menuLayout.buttonRect(-1, row++), true, new int[0]);
        this.playerSpawnConfigControl.setDisplayName("Starting Ship: " + this.playerSpawnConfigNames.get(this.playerSpawnConfigIndex));
        this.controls.add(this.playerSpawnConfigControl);
        this.okControl = new SolUiControl(menuLayout.buttonRect(-1, row++), true, gameOptions.getKeyEscape());
        this.okControl.setDisplayName("OK");
        this.controls.add(this.okControl);
        this.cancelControl = new SolUiControl(menuLayout.buttonRect(-1, row), true, gameOptions.getKeyEscape());
        this.cancelControl.setDisplayName("Cancel");
        this.controls.add(this.cancelControl);
        this.backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        if (this.okControl.isJustOff()) {
            solApplication.play(false, this.playerSpawnConfigNames.get(this.playerSpawnConfigIndex), true);
            return;
        }
        if (this.cancelControl.isJustOff()) {
            solApplication.getInputManager().setScreen(solApplication, solApplication.getMenuScreens().newGame);
            return;
        }
        if (this.systemCountControl.isJustOff()) {
            int systemCount = (this.numberOfSystems + 1) % 10;
            if (systemCount < 2) {
                systemCount = 2;
            }
            this.numberOfSystems = systemCount;
            this.systemCountControl.setDisplayName("Systems: " + this.numberOfSystems);
        }
        if (this.playerSpawnConfigControl.isJustOff()) {
            this.playerSpawnConfigIndex = (this.playerSpawnConfigIndex + 1) % this.playerSpawnConfigNames.size();
            this.playerSpawnConfigControl.setDisplayName("Starting Ship: " + this.playerSpawnConfigNames.get(this.playerSpawnConfigIndex));
        }
        solApplication.getMenuBackgroundManager().update();
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.drawString("Warning: This will erase any old ship you might have had!", 0.5f * this.displayDimensions.getRatio(), 0.3f, 1.0f, true, SolColor.WHITE);
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
        solApplication.getMenuBackgroundManager().draw(uiDrawer);
    }

    private void loadPlayerSpawnConfigs() {
        Set<ResourceUrn> configUrnList = Assets.getAssetHelper().listAssets(Json.class, "playerSpawnConfig");
        for (ResourceUrn configUrn : configUrnList) {
            JSONObject rootNode = Validator.getValidatedJSON(configUrn.toString(), "engine:schemaPlayerSpawnConfig");
            for (String s : rootNode.keySet()) {
                this.playerSpawnConfigNames.add(s);
            }
        }
    }

    public int getNumberOfSystems() {
        return this.numberOfSystems;
    }
}

