/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.menu.MenuScreens;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class OptionsScreen
extends SolUiBaseScreen {
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;
    private final TextureAtlas.AtlasRegion backgroundTexture;
    private final SolUiControl backControl;
    private final SolUiControl resolutionControl;
    private final SolUiControl inputTypeControl;
    private final SolUiControl inputMapControl;
    private final SolUiControl soundVolumeControl;
    private final SolUiControl musicVolumeControl;
    private final SolUiControl mapScrollSpeedControl;

    OptionsScreen(boolean mobile, MenuLayout menuLayout, GameOptions gameOptions) {
        int rowNo = mobile ? 0 : -3;
        this.musicVolumeControl = new SolUiControl(menuLayout.buttonRect(-1, rowNo++), true, new int[0]);
        this.musicVolumeControl.setDisplayName("Music Volume");
        this.controls.add(this.musicVolumeControl);
        this.soundVolumeControl = new SolUiControl(menuLayout.buttonRect(-1, rowNo++), true, new int[0]);
        this.soundVolumeControl.setDisplayName("Sound Volume");
        this.controls.add(this.soundVolumeControl);
        this.resolutionControl = new SolUiControl(mobile ? null : menuLayout.buttonRect(-1, rowNo++), true, new int[0]);
        this.resolutionControl.setDisplayName("Resolution");
        this.controls.add(this.resolutionControl);
        this.mapScrollSpeedControl = new SolUiControl(menuLayout.buttonRect(-1, rowNo++), true, new int[0]);
        this.mapScrollSpeedControl.setDisplayName("Map Pan Speed");
        this.controls.add(this.mapScrollSpeedControl);
        this.inputTypeControl = new SolUiControl(mobile ? null : menuLayout.buttonRect(-1, rowNo++), true, 31);
        this.inputTypeControl.setDisplayName("Control Type");
        this.controls.add(this.inputTypeControl);
        this.inputMapControl = new SolUiControl(mobile ? null : menuLayout.buttonRect(-1, rowNo++), true, 41);
        this.inputMapControl.setDisplayName("Controls");
        this.controls.add(this.inputMapControl);
        int n = ++rowNo;
        ++rowNo;
        this.backControl = new SolUiControl(menuLayout.buttonRect(-1, n), true, gameOptions.getKeyEscape());
        this.backControl.setDisplayName("Back");
        this.controls.add(this.backControl);
        this.backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolInputManager inputManager = solApplication.getInputManager();
        MenuScreens screens = solApplication.getMenuScreens();
        GameOptions options = solApplication.getOptions();
        if (this.resolutionControl.isJustOff()) {
            inputManager.setScreen(solApplication, screens.resolutionScreen);
        }
        String controlName = solApplication.getOptions().controlType.getHumanName();
        this.inputTypeControl.setDisplayName("Input: " + controlName);
        if (this.inputTypeControl.isJustOff()) {
            solApplication.getOptions().advanceControlType(false);
        }
        if (this.backControl.isJustOff()) {
            inputManager.setScreen(solApplication, screens.main);
        }
        if (this.inputMapControl.isJustOff()) {
            switch (solApplication.getOptions().controlType) {
                case KEYBOARD: {
                    screens.inputMapScreen.setOperations(screens.inputMapScreen.inputMapKeyboardScreen);
                    break;
                }
                case MIXED: {
                    screens.inputMapScreen.setOperations(screens.inputMapScreen.inputMapMixedScreen);
                    break;
                }
                case CONTROLLER: {
                    screens.inputMapScreen.setOperations(screens.inputMapScreen.inputMapControllerScreen);
                }
            }
            inputManager.setScreen(solApplication, screens.inputMapScreen);
        }
        this.soundVolumeControl.setDisplayName("Sound Volume: " + options.sfxVolume.getName());
        if (this.soundVolumeControl.isJustOff()) {
            options.advanceSoundVolMul();
        }
        this.musicVolumeControl.setDisplayName("Music Volume: " + options.musicVolume.getName());
        if (this.musicVolumeControl.isJustOff()) {
            options.advanceMusicVolMul();
            solApplication.getMusicManager().changeVolume(options);
        }
        this.mapScrollSpeedControl.setDisplayName("Map Pan Speed: " + options.getMapScrollSpeed());
        if (this.mapScrollSpeedControl.isJustOff()) {
            options.advanceMapScrollSpeed();
        }
        solApplication.getMenuBackgroundManager().update();
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
        solApplication.getMenuBackgroundManager().draw(uiDrawer);
    }
}

