/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.Graphics;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.destinationsol.menu.Resolution;

public class ResolutionProvider {
    private List<Resolution> resolutions;
    private int currentPosition = 0;

    public ResolutionProvider(List<Graphics.DisplayMode> displayModes) {
        Stream<Resolution> allResolutions = displayModes.stream().map(displayMode -> new Resolution(displayMode.width, displayMode.height));
        this.resolutions = allResolutions.filter(this.distinctByStringValue()).sorted(Comparator.comparing(Resolution::getWidth).thenComparing(Resolution::getHeight)).collect(Collectors.toList());
    }

    public Resolution increase() {
        ++this.currentPosition;
        this.currentPosition %= this.resolutions.size();
        return this.resolutions.get(this.currentPosition);
    }

    public Resolution getResolution() {
        return this.resolutions.get(this.currentPosition);
    }

    private Predicate<Resolution> distinctByStringValue() {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(t.toString());
    }
}

