/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionScreen
extends SolUiBaseScreen {
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;
    private static final Logger logger = LoggerFactory.getLogger(ResolutionScreen.class);
    private final TextureAtlas.AtlasRegion backgroundTexture;
    private final SolUiControl closeControl;
    private final SolUiControl resolutionControl;
    private final SolUiControl fullscreenControl;

    ResolutionScreen(MenuLayout menuLayout, GameOptions gameOptions) {
        this.resolutionControl = new SolUiControl(menuLayout.buttonRect(-1, 2), true, new int[0]);
        this.resolutionControl.setDisplayName("Resolution");
        this.controls.add(this.resolutionControl);
        this.fullscreenControl = new SolUiControl(menuLayout.buttonRect(-1, 3), true, new int[0]);
        this.fullscreenControl.setDisplayName("Fullscreen");
        this.controls.add(this.fullscreenControl);
        this.closeControl = new SolUiControl(menuLayout.buttonRect(-1, 4), true, gameOptions.getKeyEscape());
        this.closeControl.setDisplayName("Back");
        this.controls.add(this.closeControl);
        this.backgroundTexture = Assets.getAtlasRegion("engine:mainMenuBg", Texture.TextureFilter.Linear);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolInputManager inputManager = solApplication.getInputManager();
        GameOptions options = solApplication.getOptions();
        if (this.closeControl.isJustOff()) {
            if (options.fullscreen) {
                Graphics.DisplayMode mode = null;
                for (Graphics.DisplayMode displayMode : Gdx.graphics.getDisplayModes()) {
                    if (displayMode.width != options.x || displayMode.height != options.y) continue;
                    mode = displayMode;
                }
                if (mode != null) {
                    Gdx.graphics.setFullscreenMode(mode);
                } else {
                    logger.warn("The resolution {}x{} is not supported in fullscreen mode!", (Object)options.x, (Object)options.y);
                }
            } else {
                Gdx.graphics.setWindowedMode(options.x, options.y);
            }
            inputManager.setScreen(solApplication, solApplication.getMenuScreens().options);
            return;
        }
        this.resolutionControl.setDisplayName(options.x + "x" + options.y);
        if (this.resolutionControl.isJustOff()) {
            options.advanceResolution();
        }
        this.fullscreenControl.setDisplayName(options.fullscreen ? "Fullscreen" : "Windowed");
        if (this.fullscreenControl.isJustOff()) {
            options.advanceFullscreen();
        }
        solApplication.getMenuBackgroundManager().update();
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw((TextureRegion)this.backgroundTexture, this.displayDimensions.getRatio(), 1.0f, this.displayDimensions.getRatio() / 2.0f, 0.5f, this.displayDimensions.getRatio() / 2.0f, 0.5f, 0.0f, SolColor.WHITE);
        solApplication.getMenuBackgroundManager().draw(uiDrawer);
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.drawString("Click 'Back' to apply changes", 0.5f * this.displayDimensions.getRatio(), 0.3f, 1.0f, true, SolColor.WHITE);
    }
}

