/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu.background;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColorUtil;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.menu.background.MenuBackgroundObject;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.UiDrawer;

public class MenuBackgroundAsteroidManager {
    private final DisplayDimensions displayDimensions;
    private final CollisionMeshLoader asteroidMeshLoader;
    private List<TextureAtlas.AtlasRegion> availableAsteroidTextures;
    private List<MenuBackgroundObject> backgroundAsteroids;
    private List<MenuBackgroundObject> retainedBackgroundAsteroids;
    private World world;
    private final int NUMBER_OF_ASTEROIDS = 10;

    public MenuBackgroundAsteroidManager(DisplayDimensions displayDimensions, World world) {
        this.displayDimensions = displayDimensions;
        this.world = world;
        this.asteroidMeshLoader = new CollisionMeshLoader("engine:asteroids");
        this.availableAsteroidTextures = Assets.listTexturesMatching("engine:asteroid_.*");
        this.backgroundAsteroids = new ArrayList<MenuBackgroundObject>();
        this.retainedBackgroundAsteroids = new ArrayList<MenuBackgroundObject>();
        for (int i = 0; i < 10; ++i) {
            this.backgroundAsteroids.add(this.buildAsteroid());
        }
    }

    public void update() {
        this.retainedBackgroundAsteroids.clear();
        for (MenuBackgroundObject backgroundObject : this.backgroundAsteroids) {
            boolean isInHeight;
            backgroundObject.update();
            boolean isInWidth = Math.abs(backgroundObject.getPosition().x) < 5.0f * this.displayDimensions.getRatio() * 0.8f;
            boolean bl = isInHeight = Math.abs(backgroundObject.getPosition().y) < 4.0f;
            if (isInWidth && isInHeight) {
                this.retainedBackgroundAsteroids.add(backgroundObject);
                continue;
            }
            this.retainedBackgroundAsteroids.add(this.buildAsteroid());
        }
        this.backgroundAsteroids.clear();
        this.backgroundAsteroids.addAll(this.retainedBackgroundAsteroids);
    }

    public void draw(UiDrawer uiDrawer) {
        for (MenuBackgroundObject backgroundObject : this.backgroundAsteroids) {
            backgroundObject.draw(uiDrawer);
        }
    }

    public MenuBackgroundObject buildAsteroid() {
        Vector2 position;
        Vector2 velocity;
        TextureAtlas.AtlasRegion texture = SolRandom.randomElement(this.availableAsteroidTextures);
        boolean small = SolRandom.test(0.8f);
        float size = (small ? 1.0f : 2.0f) * SolRandom.randomFloat(0.5f, 1.0f);
        Color tint = new Color();
        SolColorUtil.fromHSB(SolRandom.randomFloat(0.0f, 1.0f), 0.25f, 1.0f, 0.7f, tint);
        float ratio = this.displayDimensions.getRatio();
        float viewportHeight = 5.0f;
        if (SolRandom.test(0.5f)) {
            boolean fromLeft = SolRandom.test(0.5f);
            velocity = new Vector2((float)(fromLeft ? 1 : -1) * SolRandom.randomFloat(0.75f, 2.5f), SolRandom.randomFloat(0.75f, 2.5f));
            position = new Vector2((float)(fromLeft ? -1 : 1) * viewportHeight * ratio * 0.8f, SolRandom.randomFloat(-viewportHeight * 0.8f, viewportHeight * 0.8f));
        } else {
            boolean fromTop = SolRandom.test(0.5f);
            velocity = new Vector2(SolRandom.randomFloat(0.75f, 2.5f), (float)(fromTop ? 1 : -1) * SolRandom.randomFloat(0.75f, 2.5f));
            position = new Vector2(SolRandom.randomFloat(-viewportHeight * ratio, viewportHeight * ratio), (float)(fromTop ? -1 : 1) * viewportHeight * 0.8f);
        }
        float angle = SolRandom.randomFloat((float)Math.PI);
        float angularVelocity = SolRandom.randomFloat(1.5f);
        Body body = this.asteroidMeshLoader.getBodyAndSprite(this.world, texture, size, BodyDef.BodyType.DynamicBody, position, angle, new ArrayList<Drawable>(), 10.0f, DrawableLevel.BODIES);
        body.setLinearVelocity(velocity);
        body.setAngularVelocity(angularVelocity);
        MenuBackgroundObject asteroid = new MenuBackgroundObject(texture, size, tint, position, velocity, this.asteroidMeshLoader.getOrigin(texture.name, size).cpy(), angle, body);
        body.setUserData((Object)asteroid);
        return asteroid;
    }
}

