/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu.background;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import org.destinationsol.menu.background.MenuBackgroundAsteroidManager;
import org.destinationsol.menu.background.MenuBackgroundShipManager;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.UiDrawer;

public class MenuBackgroundManager {
    public static final float VIEWPORT_HEIGHT = 5.0f;
    private World world = new World(new Vector2(0.0f, 0.0f), true);
    private MenuBackgroundAsteroidManager asteroidManager;
    private MenuBackgroundShipManager shipManager;
    OrthographicCamera backgroundCamera;

    public MenuBackgroundManager(DisplayDimensions displayDimensions) {
        this.asteroidManager = new MenuBackgroundAsteroidManager(displayDimensions, this.world);
        this.shipManager = new MenuBackgroundShipManager(displayDimensions, this.world);
        this.backgroundCamera = new OrthographicCamera(5.0f * displayDimensions.getRatio(), -5.0f);
    }

    public void update() {
        this.asteroidManager.update();
        this.shipManager.update();
        this.world.step(0.016666668f, 6, 2);
    }

    public void draw(UiDrawer drawer) {
        drawer.setMatrix(this.backgroundCamera.combined);
        this.asteroidManager.draw(drawer);
        this.shipManager.draw(drawer);
        drawer.updateMtx();
    }
}

