/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu.background;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import org.destinationsol.ui.UiDrawer;

public class MenuBackgroundObject {
    TextureAtlas.AtlasRegion texture;
    float scale;
    Vector2 position;
    Vector2 velocity;
    Vector2 origin;
    float angle;
    Color tint;
    Body body;

    public MenuBackgroundObject(TextureAtlas.AtlasRegion texture, float scale, Color tint, Vector2 position, Vector2 velocity, Vector2 origin, float angle, Body body) {
        this.texture = texture;
        this.scale = scale;
        this.tint = tint;
        this.position = position;
        this.velocity = velocity;
        this.origin = origin;
        this.angle = angle;
        this.body = body;
    }

    public void setParamsFromBody() {
        this.position.set(this.body.getPosition());
        this.velocity.set(this.body.getLinearVelocity());
        this.angle = this.body.getAngle() * 57.295776f;
    }

    public void update() {
        this.setParamsFromBody();
    }

    public void draw(UiDrawer drawer) {
        drawer.draw((TextureRegion)this.texture, this.scale, this.scale, this.origin.x, this.origin.y, this.position.x, this.position.y, this.angle, this.tint);
    }

    public Vector2 getPosition() {
        return this.position;
    }
}

