/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.menu.background;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.menu.background.MenuBackgroundObject;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.UiDrawer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;

public class MenuBackgroundShipManager {
    private CollisionMeshLoader shipMeshLoader;
    private List<String> availableShips;
    private List<MenuBackgroundObject> backgroundShips;
    private World world;

    public MenuBackgroundShipManager(DisplayDimensions displayDimensions, World world) {
        this.world = world;
        this.shipMeshLoader = new CollisionMeshLoader();
        this.availableShips = new ArrayList<String>();
        this.backgroundShips = new ArrayList<MenuBackgroundObject>();
        Set<ResourceUrn> configUrnList = Assets.getAssetHelper().listAssets(Json.class, "menuBackgroundShipConfig");
        for (ResourceUrn configUrn : configUrnList) {
            JSONObject rootNode = Assets.getJson(configUrn.toString()).getJsonValue();
            JSONArray ships = rootNode.getJSONArray("Menu Ships");
            for (int index = 0; index < ships.length(); ++index) {
                Object shipUrn = ships.get(index);
                if (this.availableShips.contains(shipUrn.toString())) continue;
                this.availableShips.add(shipUrn.toString());
            }
        }
    }

    public void addShip(String urnString) {
        TextureAtlas.AtlasRegion texture = Assets.getAtlasRegion(urnString);
        JSONObject rootNode = Validator.getValidatedJSON(urnString, "engine:schemaHullConfig");
        JSONObject rigidBodyNode = rootNode.getJSONObject("rigidBody");
        this.shipMeshLoader.readRigidBody(rigidBodyNode, urnString);
        float scale = 1.0f;
        float angle = 105.0f;
        Vector2 position = new Vector2(4.0f, -4.0f);
        Vector2 velocity = new Vector2(0.5f, 0.0f);
        velocity.rotate(angle);
        Body body = this.shipMeshLoader.getBodyAndSprite(this.world, texture, scale, BodyDef.BodyType.DynamicBody, position, angle, new ArrayList<Drawable>(), Float.MAX_VALUE, DrawableLevel.BODIES);
        body.setLinearVelocity(velocity);
        Vector2 origin = this.shipMeshLoader.getOrigin(texture.name, scale);
        MenuBackgroundObject ship = new MenuBackgroundObject(texture, scale, SolColor.WHITE, position, velocity, origin.cpy(), angle, body);
        this.backgroundShips.add(ship);
    }

    public void update() {
        this.backgroundShips.forEach(ship -> ship.update());
        this.backgroundShips.removeIf(ship -> ship.getPosition().y >= 3.0f);
        if (this.backgroundShips.isEmpty()) {
            String nextShipUrn = SolRandom.randomElement(this.availableShips);
            this.addShip(nextShipUrn);
        }
    }

    public void draw(UiDrawer uiDrawer) {
        this.backgroundShips.forEach(ship -> ship.draw(uiDrawer));
    }
}

