/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.mercenary;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.Faction;
import org.destinationsol.game.Hero;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.AiPilot;
import org.destinationsol.game.input.Guardian;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class MercenaryUtils {
    public static boolean createMerc(SolGame game, Hero hero, MercItem mercItem) {
        ShipConfig config = mercItem.getConfig();
        Guardian guardian = new Guardian(game, config.hull, hero.getPilot(), hero.getPosition(), hero.getHull().config, SolRandom.randomFloat(180.0f));
        AiPilot pilot = new AiPilot(guardian, true, Faction.LAANI, false, "Merc", 5.4f);
        Vector2 position = MercenaryUtils.getPos(game, hero, config.hull);
        if (position == null) {
            return false;
        }
        SolShip merc = game.getShipBuilder().buildNewFar(game, position, new Vector2(), 0.0f, 0.0f, pilot, config.items, config.hull, null, true, config.money, null, true).toObject(game);
        merc.setMerc(mercItem);
        mercItem.setSolShip(merc);
        game.getHero().getMercs().add(mercItem);
        game.getObjectManager().addObjNow(game, merc);
        return true;
    }

    private static Vector2 getPos(SolGame game, Hero hero, HullConfig hull) {
        Vector2 position = new Vector2();
        float dist = hero.getHull().config.getApproxRadius() + 1.5f + hull.getApproxRadius();
        Vector2 heroPos = hero.getPosition();
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet(heroPos);
        boolean nearGround = nearestPlanet.isNearGround(heroPos);
        float fromPlanet = SolMath.angle(nearestPlanet.getPosition(), heroPos);
        for (int i = 0; i < 50; ++i) {
            float relAngle = nearGround ? fromPlanet : (float)SolRandom.randomInt(180);
            SolMath.fromAl(position, relAngle, dist);
            position.add(heroPos);
            if (game.isPlaceEmpty(position, false)) {
                return position;
            }
            dist += 1.5f;
        }
        return null;
    }
}

