/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.modules;

import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ReflectPermission;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Paths;
import java.security.Policy;
import java.util.HashSet;
import java.util.Set;
import org.destinationsol.assets.AssetHelper;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.emitters.Emitter;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.music.OggMusic;
import org.destinationsol.assets.sound.OggSound;
import org.destinationsol.assets.textures.DSTexture;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.entity.EntityIterator;
import org.terasology.gestalt.entitysystem.entity.EntityManager;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventResult;
import org.terasology.gestalt.entitysystem.event.ReceiveEvent;
import org.terasology.gestalt.entitysystem.prefab.GeneratedFromRecipeComponent;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.module.ModuleFactory;
import org.terasology.gestalt.module.ModulePathScanner;
import org.terasology.gestalt.module.ModuleRegistry;
import org.terasology.gestalt.module.TableModuleRegistry;
import org.terasology.gestalt.module.sandbox.APIScanner;
import org.terasology.gestalt.module.sandbox.ModuleSecurityManager;
import org.terasology.gestalt.module.sandbox.ModuleSecurityPolicy;
import org.terasology.gestalt.module.sandbox.PermissionProviderFactory;
import org.terasology.gestalt.module.sandbox.StandardPermissionProviderFactory;

public class ModuleManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManager.class);
    protected static final String[] API_WHITELIST = new String[]{"java.lang", "java.lang.invoke", "java.lang.ref", "java.math", "java.util", "java.util.concurrent", "java.util.concurrent.atomic", "java.util.concurrent.locks", "java.util.function", "java.util.regex", "java.util.stream", "java.util.zip", "java.awt", "java.awt.geom", "java.awt.image", "jdk.internal.reflect", "com.google.common.annotations", "com.google.common.cache", "com.google.common.collect", "com.google.common.base", "com.google.common.math", "com.google.common.primitives", "com.google.common.util.concurrent", "gnu.trove", "gnu.trove.decorator", "gnu.trove.function", "gnu.trove.iterator", "gnu.trove.iterator.hash", "gnu.trove.list", "gnu.trove.list.array", "gnu.trove.list.linked", "gnu.trove.map", "gnu.trove.map.hash", "gnu.trove.map.custom_hash", "gnu.trove.procedure", "gnu.trove.procedure.array", "gnu.trove.queue", "gnu.trove.set", "gnu.trove.set.hash", "gnu.trove.stack", "gnu.trove.stack.array", "gnu.trove.strategy", "javax.vecmath", "sun.reflect", "org.json", "com.badlogic.gdx.math", "com.badlogic.gdx.graphics", "com.badlogic.gdx.graphics.g2d", "com.badlogic.gdx.physics", "com.badlogic.gdx.physics.box2d"};
    protected static final Class<?>[] CLASS_WHITELIST = new Class[]{InvocationTargetException.class, LoggerFactory.class, Logger.class, ByteBuffer.class, IntBuffer.class, Array.class, DataInput.class, DataOutput.class, EOFException.class, FileNotFoundException.class, IOException.class, UTFDataFormatException.class, Reader.class, BufferedReader.class, FilterReader.class, InputStreamReader.class, PipedReader.class, StringReader.class, Writer.class, BufferedWriter.class, FilterWriter.class, OutputStreamWriter.class, PipedWriter.class, StringWriter.class, InputStream.class, BufferedInputStream.class, ByteArrayInputStream.class, DataInputStream.class, FilterInputStream.class, PipedInputStream.class, PushbackInputStream.class, OutputStream.class, BufferedOutputStream.class, ByteArrayOutputStream.class, DataOutputStream.class, FilterOutputStream.class, PipedOutputStream.class, Component.class, Event.class, EntityRef.class, EntityIterator.class, EntityManager.class, EventResult.class, ReceiveEvent.class, GeneratedFromRecipeComponent.class};
    protected static ModuleEnvironment environment;
    protected ModuleRegistry registry;
    protected Module engineModule;

    public void init() throws Exception {
        try {
            ModuleFactory moduleFactory = new ModuleFactory();
            this.engineModule = moduleFactory.createPackageModule("org.destinationsol");
            this.registry = new TableModuleRegistry();
            File modulesRoot = Paths.get(".", new String[0]).resolve("modules").toFile();
            ModulePathScanner scanner = new ModulePathScanner(moduleFactory);
            scanner.scan(this.registry, modulesRoot, new File[0]);
            HashSet requiredModules = Sets.newHashSet();
            this.registry.add((Object)this.engineModule);
            requiredModules.addAll(this.registry);
            this.loadEnvironment(requiredModules);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void loadEnvironment(Set<Module> modules) {
        StandardPermissionProviderFactory permissionFactory = new StandardPermissionProviderFactory();
        for (String api : API_WHITELIST) {
            permissionFactory.getBasePermissionSet().addAPIPackage(api);
        }
        for (Class<?> apiClass : CLASS_WHITELIST) {
            permissionFactory.getBasePermissionSet().addAPIClass((Class)apiClass);
        }
        permissionFactory.getBasePermissionSet().grantPermission("com.google.gson", ReflectPermission.class);
        permissionFactory.getBasePermissionSet().grantPermission("com.google.gson.internal", ReflectPermission.class);
        permissionFactory.getBasePermissionSet().grantPermission("com.google.gson", RuntimePermission.class);
        permissionFactory.getBasePermissionSet().grantPermission("com.google.gson.internal", RuntimePermission.class);
        ConfigurationBuilder config = new ConfigurationBuilder().addClassLoader(ClasspathHelper.contextClassLoader()).addUrls(ClasspathHelper.forClassLoader()).addScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        APIScanner scanner = new APIScanner(permissionFactory);
        scanner.scan(reflections);
        Policy.setPolicy((Policy)new ModuleSecurityPolicy());
        System.setSecurityManager((SecurityManager)new ModuleSecurityManager());
        environment = new ModuleEnvironment(modules, (PermissionProviderFactory)permissionFactory);
    }

    public ModuleEnvironment getEnvironment() {
        return environment;
    }

    public static ModuleEnvironment getEnvironmentStatic() {
        return environment;
    }

    public void printAvailableModules() {
        AssetHelper assetHelper = Assets.getAssetHelper();
        Set<ResourceUrn> jsonList = assetHelper.list(Json.class);
        Set<ResourceUrn> emitterList = assetHelper.list(Emitter.class);
        Set<ResourceUrn> soundList = assetHelper.list(OggSound.class);
        Set<ResourceUrn> musicList = assetHelper.list(OggMusic.class);
        Set<ResourceUrn> textureList = assetHelper.list(DSTexture.class);
        for (Module module : this.registry) {
            String assetName;
            String moduleName = module.getId().toString();
            logger.info("Module Discovered: {}", (Object)module.toString());
            int armors = 0;
            int abilityCharges = 0;
            int clips = 0;
            int engines = 0;
            int shields = 0;
            int jsonOthers = 0;
            int emitters = 0;
            int sounds = 0;
            int music = 0;
            int textures = 0;
            for (ResourceUrn assetUrn : jsonList) {
                assetName = assetUrn.toString();
                if (!assetName.startsWith(moduleName + ":")) continue;
                if (assetName.endsWith("Armor")) {
                    ++armors;
                    continue;
                }
                if (assetName.endsWith("AbilityCharge")) {
                    ++abilityCharges;
                    continue;
                }
                if (assetName.endsWith("Clip")) {
                    ++clips;
                    continue;
                }
                if (assetName.endsWith("Engine")) {
                    ++engines;
                    continue;
                }
                if (assetName.endsWith("Shield")) {
                    ++shields;
                    continue;
                }
                ++jsonOthers;
            }
            for (ResourceUrn assetUrn : emitterList) {
                assetName = assetUrn.toString();
                if (!assetName.startsWith(moduleName + ":")) continue;
                ++emitters;
            }
            for (ResourceUrn assetUrn : soundList) {
                assetName = assetUrn.toString();
                if (!assetName.startsWith(moduleName + ":")) continue;
                ++sounds;
            }
            for (ResourceUrn assetUrn : musicList) {
                assetName = assetUrn.toString();
                if (!assetName.startsWith(moduleName + ":")) continue;
                ++music;
            }
            for (ResourceUrn assetUrn : textureList) {
                assetName = assetUrn.toString();
                if (!assetName.startsWith(moduleName + ":")) continue;
                ++textures;
            }
            logger.info("\t-Items:");
            logger.info("\t\t-Armors: {}", (Object)armors);
            logger.info("\t\t-AbilityCharges: {}", (Object)abilityCharges);
            logger.info("\t\t-Clips: {}", (Object)clips);
            logger.info("\t\t-Engines: {}", (Object)engines);
            logger.info("\t\t-Shields: {}", (Object)shields);
            logger.info("\t\t-Others: {}", (Object)jsonOthers);
            logger.info("\t-Emitters: {}", (Object)emitters);
            logger.info("\t-Sounds: {}", (Object)sounds);
            logger.info("\t-Music: {}", (Object)music);
            logger.info("\t-Textures: {}", (Object)textures);
            logger.info("");
        }
    }
}

