/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.assets.sound.PlayableSound;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.context.Context;
import org.destinationsol.ui.SolInputProcessor;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.SolUiScreen;
import org.destinationsol.ui.TutorialManager;
import org.destinationsol.ui.UiDrawer;

public class SolInputManager {
    private static final float CURSOR_SZ = 0.07f;
    private static final float WARN_PERC_GROWTH_TIME = 1.0f;
    private static final int POINTER_COUNT = 4;
    private static final float CURSOR_SHOW_TIME = 3.0f;
    private static Cursor hiddenCursor;
    private final List<SolUiScreen> screens = new ArrayList<SolUiScreen>();
    private final List<SolUiScreen> screenToRemove = new ArrayList<SolUiScreen>();
    private final List<SolUiScreen> screensToAdd = new ArrayList<SolUiScreen>();
    private final InputPointer[] inputPointers;
    private final InputPointer flashInputPointer;
    private final Vector2 mousePos;
    private final Vector2 mousePrevPos;
    private final Vector2 lastTouchDragPosition;
    private final Vector2 drag;
    private final PlayableSound hoverSound;
    private final TextureAtlas.AtlasRegion uiCursor;
    private final Color warnColor;
    private final Context context;
    private float mouseIdleTime;
    private final boolean osIsLinux;
    private TextureAtlas.AtlasRegion currCursor;
    private boolean mouseOnUi;
    private float warnPercentage;
    private boolean warnPercGrows;
    private Boolean scrolledUp;
    public boolean touchDragged;

    public SolInputManager(OggSoundManager soundManager, Context context) {
        this.context = context;
        this.inputPointers = new InputPointer[4];
        for (int i = 0; i < 4; ++i) {
            this.inputPointers[i] = new InputPointer();
        }
        SolInputProcessor sip = new SolInputProcessor(this);
        Gdx.input.setInputProcessor((InputProcessor)sip);
        this.flashInputPointer = new InputPointer();
        this.mousePos = new Vector2();
        this.mousePrevPos = new Vector2();
        this.lastTouchDragPosition = new Vector2();
        this.drag = new Vector2();
        Pixmap pixmap = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        hiddenCursor = Gdx.graphics.newCursor(pixmap, 0, 0);
        pixmap.dispose();
        Gdx.input.setCursorCatched(false);
        this.setMouseCursorHidden();
        this.uiCursor = Assets.getAtlasRegion("engine:uiCursor");
        this.warnColor = new Color(SolColor.UI_WARN);
        this.hoverSound = soundManager.getSound("engine:uiHover");
        this.osIsLinux = System.getProperty("os.name").equals("Linux");
    }

    private static void setPointerPosition(InputPointer inputPointer, int screenX, int screenY) {
        int h = Gdx.graphics.getHeight();
        inputPointer.x = 1.0f * (float)screenX / (float)h;
        inputPointer.y = 1.0f * (float)screenY / (float)h;
    }

    private void setMouseCursorHidden() {
        Gdx.graphics.setCursor(hiddenCursor);
    }

    void maybeFlashPressed(int keyCode) {
        for (SolUiScreen screen : this.screens) {
            boolean consumed = false;
            List<SolUiControl> controls = screen.getControls();
            for (SolUiControl control : controls) {
                if (!control.maybeFlashPressed(keyCode)) continue;
                consumed = true;
            }
            if (!consumed) continue;
            return;
        }
    }

    void maybeFlashPressed(int x, int y) {
        this.lastTouchDragPosition.set((float)x, (float)y);
        SolInputManager.setPointerPosition(this.flashInputPointer, x, y);
        for (SolUiScreen screen : this.screens) {
            List<SolUiControl> controls = screen.getControls();
            for (SolUiControl control : controls) {
                if (!control.maybeFlashPressed(this.flashInputPointer)) continue;
                return;
            }
            if (!screen.isCursorOnBackground(this.flashInputPointer)) continue;
            return;
        }
    }

    void maybeTouchDragged(int x, int y) {
        Vector2 newPosition = new Vector2((float)x, (float)y);
        this.drag.set(newPosition.sub(this.lastTouchDragPosition));
        this.touchDragged = this.lastTouchDragPosition.x != (float)x || this.lastTouchDragPosition.y != (float)y;
        this.lastTouchDragPosition.set((float)x, (float)y);
    }

    public void setScreen(SolApplication solApplication, SolUiScreen screen) {
        for (SolUiScreen oldScreen : this.screens) {
            this.removeScreen(oldScreen, solApplication);
        }
        this.addScreen(solApplication, screen);
    }

    public void addScreen(SolApplication solApplication, SolUiScreen screen) {
        this.screensToAdd.add(screen);
        screen.onAdd(solApplication);
    }

    private void removeScreen(SolUiScreen screen, SolApplication solApplication) {
        this.screenToRemove.add(screen);
        List<SolUiControl> controls = screen.getControls();
        for (SolUiControl control : controls) {
            control.blur();
        }
        screen.blurCustom(solApplication);
    }

    public boolean isScreenOn(SolUiScreen screen) {
        return this.screens.contains(screen);
    }

    public void update(SolApplication solApplication) {
        TutorialManager tutorialManager;
        boolean mobile = solApplication.isMobile();
        SolGame game = solApplication.getGame();
        if (!mobile && solApplication.getOptions().controlType == GameOptions.ControlType.MIXED && game != null && this.getTopScreen() != game.getScreens().menuScreen) {
            if (!Gdx.input.isCursorCatched() && !this.osIsLinux) {
                Gdx.input.setCursorCatched(true);
            }
            this.maybeFixMousePos();
        } else if (Gdx.input.isCursorCatched()) {
            Gdx.input.setCursorCatched(false);
        }
        this.updatePointers();
        boolean consumed = false;
        this.mouseOnUi = false;
        boolean clickOutsideReacted = false;
        for (SolUiScreen screen : this.screens) {
            boolean consumedNow = false;
            List<SolUiControl> controls = screen.getControls();
            for (SolUiControl control : controls) {
                Rectangle area;
                control.update(this.inputPointers, this.currCursor != null, !consumed, this, solApplication);
                if (control.isOn() || control.isJustOff()) {
                    consumedNow = true;
                }
                if ((area = control.getScreenArea()) == null || !area.contains(this.mousePos)) continue;
                this.mouseOnUi = true;
            }
            if (consumedNow) {
                consumed = true;
            }
            boolean clickedOutside = false;
            if (!consumed) {
                for (InputPointer inputPointer : this.inputPointers) {
                    boolean onBackground = screen.isCursorOnBackground(inputPointer);
                    if (inputPointer.pressed && onBackground) {
                        clickedOutside = false;
                        consumed = true;
                        break;
                    }
                    if (onBackground || !inputPointer.isJustUnPressed() || clickOutsideReacted) continue;
                    clickedOutside = true;
                }
            }
            if (clickedOutside && screen.reactsToClickOutside()) {
                clickOutsideReacted = true;
            }
            if (screen.isCursorOnBackground(this.inputPointers[0])) {
                this.mouseOnUi = true;
            }
            screen.updateCustom(solApplication, this.inputPointers, clickedOutside);
        }
        TutorialManager tutorialManager2 = tutorialManager = game == null ? null : this.context.get(TutorialManager.class);
        if (tutorialManager != null && tutorialManager.isFinished()) {
            solApplication.finishGame();
        }
        this.updateCursor(solApplication);
        this.addRemoveScreens();
        this.updateWarnPerc();
        this.scrolledUp = null;
        this.touchDragged = false;
    }

    private void updateWarnPerc() {
        float dif = (float)SolMath.toInt(this.warnPercGrows) * 0.016666668f / 1.0f;
        this.warnPercentage += dif;
        if (this.warnPercentage < 0.0f || 1.0f < this.warnPercentage) {
            this.warnPercentage = SolMath.clamp(this.warnPercentage);
            this.warnPercGrows = !this.warnPercGrows;
        }
        this.warnColor.a = this.warnPercentage * 0.5f;
    }

    private void addRemoveScreens() {
        this.screens.removeAll(this.screenToRemove);
        this.screenToRemove.clear();
        for (SolUiScreen screen : this.screensToAdd) {
            if (this.isScreenOn(screen)) continue;
            this.screens.add(0, screen);
        }
        this.screensToAdd.clear();
    }

    private void updateCursor(SolApplication solApplication) {
        if (solApplication.isMobile()) {
            return;
        }
        SolGame game = solApplication.getGame();
        this.mousePos.set(this.inputPointers[0].x, this.inputPointers[0].y);
        if (solApplication.getOptions().controlType == GameOptions.ControlType.MIXED || solApplication.getOptions().controlType == GameOptions.ControlType.MOUSE) {
            if (game == null || this.mouseOnUi) {
                this.currCursor = this.uiCursor;
            } else {
                this.currCursor = game.getScreens().mainGameScreen.shipControl.getInGameTex();
                if (this.currCursor == null) {
                    this.currCursor = this.uiCursor;
                }
            }
            return;
        }
        if (this.mousePrevPos.epsilonEquals(this.mousePos, 0.0f) && game != null && this.getTopScreen() != game.getScreens().menuScreen) {
            this.mouseIdleTime += 0.016666668f;
            this.currCursor = this.mouseIdleTime < 3.0f ? this.uiCursor : null;
        } else {
            this.currCursor = this.uiCursor;
            this.mouseIdleTime = 0.0f;
            this.mousePrevPos.set(this.mousePos);
        }
    }

    private void maybeFixMousePos() {
        if (this.osIsLinux) {
            return;
        }
        int mouseX = Gdx.input.getX();
        int mouseY = Gdx.input.getY();
        int w = Gdx.graphics.getWidth();
        int h = Gdx.graphics.getHeight();
        mouseX = (int)MathUtils.clamp((float)mouseX, (float)0.0f, (float)w);
        mouseY = (int)MathUtils.clamp((float)mouseY, (float)0.0f, (float)h);
        Gdx.input.setCursorPosition(mouseX, mouseY);
    }

    private void updatePointers() {
        for (int i = 0; i < 4; ++i) {
            InputPointer inputPointer = this.inputPointers[i];
            int screenX = Gdx.input.getX(i);
            int screenY = Gdx.input.getY(i);
            SolInputManager.setPointerPosition(inputPointer, screenX, screenY);
            inputPointer.prevPressed = inputPointer.pressed;
            inputPointer.pressed = Gdx.input.isTouched(i);
        }
    }

    public void draw(UiDrawer uiDrawer, SolApplication solApplication) {
        TutorialManager tutorialManager;
        for (int i = this.screens.size() - 1; i >= 0; --i) {
            SolUiScreen screen = this.screens.get(i);
            uiDrawer.setTextMode(false);
            screen.drawBackground(uiDrawer, solApplication);
            List<SolUiControl> controls = screen.getControls();
            for (SolUiControl control : controls) {
                control.drawButton(uiDrawer, this.warnColor);
            }
            screen.drawImages(uiDrawer, solApplication);
            uiDrawer.setTextMode(true);
            screen.drawText(uiDrawer, solApplication);
            for (SolUiControl control : controls) {
                control.drawDisplayName(uiDrawer);
            }
        }
        uiDrawer.setTextMode(null);
        SolGame game = solApplication.getGame();
        TutorialManager tutorialManager2 = tutorialManager = game == null ? null : this.context.get(TutorialManager.class);
        if (tutorialManager != null && this.getTopScreen() != game.getScreens().menuScreen) {
            tutorialManager.draw(uiDrawer);
        }
        if (this.currCursor != null) {
            uiDrawer.draw((TextureRegion)this.currCursor, 0.07f, 0.07f, 0.035f, 0.035f, this.mousePos.x, this.mousePos.y, 0.0f, SolColor.WHITE);
        }
    }

    public Vector2 getMousePos() {
        return this.mousePos;
    }

    public InputPointer[] getPtrs() {
        return this.inputPointers;
    }

    public boolean isMouseOnUi() {
        return this.mouseOnUi;
    }

    public void playHover(SolApplication solApplication) {
        this.hoverSound.getOggSound().getSound().play(0.7f * solApplication.getOptions().sfxVolume.getVolume(), 0.7f, 0.0f);
    }

    public void playClick(SolApplication solApplication) {
        this.hoverSound.getOggSound().getSound().play(0.7f * solApplication.getOptions().sfxVolume.getVolume(), 0.9f, 0.0f);
    }

    public SolUiScreen getTopScreen() {
        return this.screens.isEmpty() ? null : this.screens.get(0);
    }

    public void scrolled(boolean up) {
        this.scrolledUp = up;
    }

    public Boolean getScrolledUp() {
        return this.scrolledUp;
    }

    public Vector2 getDrag() {
        return this.drag;
    }

    public void dispose() {
        this.hoverSound.getOggSound().getSound().dispose();
    }

    public static class InputPointer {
        public float x;
        public float y;
        public boolean pressed;
        public boolean prevPressed;

        public boolean isJustPressed() {
            return this.pressed && !this.prevPressed;
        }

        public boolean isJustUnPressed() {
            return !this.pressed && this.prevPressed;
        }
    }
}

